/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.flush;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.cayenne.ObjectId;

public class EffectiveOpId {
    private final String entityName;
    private final Map<String, Object> snapshot;
    private final ObjectId id;

    public EffectiveOpId(ObjectId id) {
        this.id = id;
        this.entityName = id.getEntityName();
        this.snapshot = new HashMap<String, Object>(id.getIdSnapshot());
        this.snapshot.entrySet().forEach(entry -> {
            if (entry.getValue() instanceof Supplier) {
                entry.setValue(((Supplier)entry.getValue()).get());
            }
        });
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EffectiveOpId that = (EffectiveOpId)o;
        if (this.id == that.id) {
            return true;
        }
        if (this.snapshot.isEmpty()) {
            return false;
        }
        if (!this.entityName.equals(that.entityName)) {
            return false;
        }
        return this.snapshot.equals(that.snapshot);
    }

    public int hashCode() {
        int result = this.entityName.hashCode();
        result = 31 * result + this.snapshot.hashCode();
        return result;
    }
}

