/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.List;
import java.util.Random;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.configuration.server.ServerRuntime;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.test.parallel.ParallelTestContainer;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class NestedDataContext_DeadlockIT
extends ServerCase {
    @Inject
    private DataContext parent;
    @Inject
    private ServerRuntime runtime;
    @Inject
    protected DBHelper dbHelper;
    protected TableHelper tArtist;

    @Before
    public void setUp() throws Exception {
        this.tArtist = new TableHelper(this.dbHelper, "ARTIST");
        this.tArtist.setColumns(new String[]{"ARTIST_ID", "ARTIST_NAME"});
    }

    private void createArtists() throws Exception {
        for (int i = 0; i < 300; ++i) {
            this.tArtist.insert(new Object[]{i + 1, "X" + i});
        }
    }

    @Test
    public void testDeadlock() throws Exception {
        this.createArtists();
        final Thread[] threads = new Thread[2];
        Random rnd = new Random(System.currentTimeMillis());
        for (int i = 0; i < threads.length; ++i) {
            threads[i] = new UpdateThread("UpdateThread-" + i, this.runtime.newContext(this.parent), rnd);
        }
        for (Thread thread : threads) {
            thread.start();
        }
        new ParallelTestContainer(){

            protected void assertResult() throws Exception {
                for (Thread thread : threads) {
                    Assert.assertFalse((String)"Deadlocked thread", (boolean)thread.isAlive());
                }
            }
        }.runTest(40000L);
    }

    static class UpdateThread
    extends Thread {
        protected ObjectContext nestedContext;
        protected Random rnd;

        UpdateThread(String name, ObjectContext nestedContext, Random rnd) {
            super(name);
            this.setDaemon(true);
            this.nestedContext = nestedContext;
            this.rnd = rnd;
        }

        @Override
        public void run() {
            List<Artist> artists = this.nestedContext.select(ObjectSelect.query(Artist.class));
            for (int i = 0; i < 100; ++i) {
                for (int j = 0; j < 5; ++j) {
                    int index = this.rnd.nextInt(artists.size());
                    Artist a = artists.get(index);
                    a.setArtistName("Y" + this.rnd.nextInt());
                }
                this.nestedContext.commitChanges();
                Thread.yield();
            }
        }
    }
}

