/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.List;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.query.QueryCacheStrategy;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class DataContextPaginatedQueryIT
extends ServerCase {
    @Inject
    protected DataContext context;
    @Inject
    protected DBHelper dbHelper;
    protected TableHelper tArtist;

    @Before
    public void setUp() throws Exception {
        this.tArtist = new TableHelper(this.dbHelper, "ARTIST");
        this.tArtist.setColumns(new String[]{"ARTIST_ID", "ARTIST_NAME"});
    }

    protected void createArtistsDataSet() throws Exception {
        this.tArtist.insert(new Object[]{33001, "artist1"});
        this.tArtist.insert(new Object[]{33002, "artist2"});
        this.tArtist.insert(new Object[]{33003, "artist3"});
        this.tArtist.insert(new Object[]{33004, "artist4"});
        this.tArtist.insert(new Object[]{33005, "artist5"});
        this.tArtist.insert(new Object[]{33006, "artist6"});
        this.tArtist.insert(new Object[]{33007, "artist7"});
        this.tArtist.insert(new Object[]{33008, "artist8"});
        this.tArtist.insert(new Object[]{33009, "artist9"});
        this.tArtist.insert(new Object[]{33010, "artist10"});
    }

    @Test
    public void testLocalCache() throws Exception {
        this.createArtistsDataSet();
        ObjectSelect<Artist> query = ObjectSelect.query(Artist.class).orderBy(Artist.ARTIST_NAME.asc()).cacheStrategy(QueryCacheStrategy.LOCAL_CACHE).pageSize(5);
        List results1 = query.select(this.context);
        Assert.assertNotNull(results1);
        List results2 = query.select(this.context);
        Assert.assertNotNull(results2);
        Assert.assertSame(results1, results2);
        results1.get(1);
        List results3 = query.select(this.context);
        Assert.assertNotNull(results3);
        Assert.assertSame(results1, results3);
        results1.get(7);
        List results4 = query.select(this.context);
        Assert.assertNotNull(results4);
        Assert.assertSame(results1, results4);
    }
}

