/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import org.apache.cayenne.Cayenne;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.QueryResponse;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.EJBQLQuery;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class DataContextEJBQLUpdateIT
extends ServerCase {
    @Inject
    private ObjectContext context;
    @Inject
    private DBHelper dbHelper;
    private TableHelper tArtist;
    private TableHelper tPainting;

    @Before
    public void setUp() throws Exception {
        this.tArtist = new TableHelper(this.dbHelper, "ARTIST");
        this.tArtist.setColumns(new String[]{"ARTIST_ID", "ARTIST_NAME"});
        this.tPainting = new TableHelper(this.dbHelper, "PAINTING");
        this.tPainting.setColumns(new String[]{"PAINTING_ID", "ARTIST_ID", "PAINTING_TITLE", "ESTIMATED_PRICE"}).setColumnTypes(new int[]{4, -5, 12, 3});
    }

    private void createThreeArtistsTwoPaintings() throws Exception {
        this.tArtist.insert(new Object[]{33001, "AA1"});
        this.tArtist.insert(new Object[]{33002, "AA2"});
        this.tArtist.insert(new Object[]{33003, "BB1"});
        this.tPainting.insert(new Object[]{33001, 33001, "P1", 3000});
        this.tPainting.insert(new Object[]{33002, 33002, "P2", 5000});
    }

    @Test
    public void testUpdateQualifier() throws Exception {
        this.createThreeArtistsTwoPaintings();
        EJBQLQuery check = new EJBQLQuery("select count(p) from Painting p WHERE p.paintingTitle is NULL or p.paintingTitle <> 'XX'");
        Object notUpdated = Cayenne.objectForQuery(this.context, check);
        Assert.assertEquals((Object)new Long(2L), (Object)notUpdated);
        String ejbql = "UPDATE Painting AS p SET p.paintingTitle = 'XX' WHERE p.paintingTitle = 'P1'";
        EJBQLQuery query = new EJBQLQuery(ejbql);
        QueryResponse result = this.context.performGenericQuery(query);
        int[] count = result.firstUpdateCount();
        Assert.assertNotNull((Object)count);
        Assert.assertEquals((long)1L, (long)count.length);
        Assert.assertEquals((long)1L, (long)count[0]);
        notUpdated = Cayenne.objectForQuery(this.context, check);
        Assert.assertEquals((Object)new Long(1L), (Object)notUpdated);
    }

    @Test
    public void testUpdateNoQualifierString() throws Exception {
        this.createThreeArtistsTwoPaintings();
        EJBQLQuery check = new EJBQLQuery("select count(p) from Painting p WHERE p.paintingTitle is NULL or p.paintingTitle <> 'XX'");
        Object notUpdated = Cayenne.objectForQuery(this.context, check);
        Assert.assertEquals((Object)new Long(2L), (Object)notUpdated);
        String ejbql = "UPDATE Painting AS p SET p.paintingTitle = 'XX'";
        EJBQLQuery query = new EJBQLQuery(ejbql);
        QueryResponse result = this.context.performGenericQuery(query);
        int[] count = result.firstUpdateCount();
        Assert.assertNotNull((Object)count);
        Assert.assertEquals((long)1L, (long)count.length);
        Assert.assertEquals((long)2L, (long)count[0]);
        notUpdated = Cayenne.objectForQuery(this.context, check);
        Assert.assertEquals((Object)new Long(0L), (Object)notUpdated);
    }

    @Test
    public void testUpdateNoQualifierNull() throws Exception {
        this.createThreeArtistsTwoPaintings();
        EJBQLQuery check = new EJBQLQuery("select count(p) from Painting p WHERE p.estimatedPrice is not null");
        Object notUpdated = Cayenne.objectForQuery(this.context, check);
        Assert.assertEquals((Object)new Long(2L), (Object)notUpdated);
        String ejbql = "UPDATE Painting AS p SET p.estimatedPrice = NULL";
        EJBQLQuery query = new EJBQLQuery(ejbql);
        QueryResponse result = this.context.performGenericQuery(query);
        int[] count = result.firstUpdateCount();
        Assert.assertNotNull((Object)count);
        Assert.assertEquals((long)1L, (long)count.length);
        Assert.assertEquals((long)2L, (long)count[0]);
        notUpdated = Cayenne.objectForQuery(this.context, check);
        Assert.assertEquals((Object)new Long(0L), (Object)notUpdated);
    }

    @Test
    public void testUpdateNoQualifierMultipleItems() throws Exception {
        this.createThreeArtistsTwoPaintings();
        EJBQLQuery check = new EJBQLQuery("select count(p) from Painting p WHERE p.estimatedPrice is NULL or p.estimatedPrice <> 1");
        Object notUpdated = Cayenne.objectForQuery(this.context, check);
        Assert.assertEquals((Object)new Long(2L), (Object)notUpdated);
        String ejbql = "UPDATE Painting AS p SET p.paintingTitle = 'XX', p.estimatedPrice = 1";
        EJBQLQuery query = new EJBQLQuery(ejbql);
        QueryResponse result = this.context.performGenericQuery(query);
        int[] count = result.firstUpdateCount();
        Assert.assertNotNull((Object)count);
        Assert.assertEquals((long)1L, (long)count.length);
        Assert.assertEquals((long)2L, (long)count[0]);
        notUpdated = Cayenne.objectForQuery(this.context, check);
        Assert.assertEquals((Object)new Long(0L), (Object)notUpdated);
    }

    @Test
    public void testUpdateNoQualifierDecimal() throws Exception {
        this.createThreeArtistsTwoPaintings();
        EJBQLQuery check = new EJBQLQuery("select count(p) from Painting p WHERE p.estimatedPrice is NULL or p.estimatedPrice <> 1.1");
        Object notUpdated = Cayenne.objectForQuery(this.context, check);
        Assert.assertEquals((Object)new Long(2L), (Object)notUpdated);
        String ejbql = "UPDATE Painting AS p SET p.estimatedPrice = 1.1";
        EJBQLQuery query = new EJBQLQuery(ejbql);
        QueryResponse result = this.context.performGenericQuery(query);
        int[] count = result.firstUpdateCount();
        Assert.assertNotNull((Object)count);
        Assert.assertEquals((long)1L, (long)count.length);
        Assert.assertEquals((long)2L, (long)count[0]);
        notUpdated = Cayenne.objectForQuery(this.context, check);
        Assert.assertEquals((Object)new Long(0L), (Object)notUpdated);
    }

    @Test
    public void testUpdateNoQualifierToOne() throws Exception {
        this.createThreeArtistsTwoPaintings();
        Artist object = Cayenne.objectForPK(this.context, Artist.class, 33003);
        EJBQLQuery check = new EJBQLQuery("select count(p) from Painting p WHERE p.toArtist <> :artist");
        check.setParameter("artist", (Object)object);
        Object notUpdated = Cayenne.objectForQuery(this.context, check);
        Assert.assertEquals((Object)new Long(2L), (Object)notUpdated);
        String ejbql = "UPDATE Painting AS p SET p.toArtist = :artist";
        EJBQLQuery query = new EJBQLQuery(ejbql);
        query.setParameter("artist", (Object)object);
        QueryResponse result = this.context.performGenericQuery(query);
        int[] count = result.firstUpdateCount();
        Assert.assertNotNull((Object)count);
        Assert.assertEquals((long)1L, (long)count.length);
        Assert.assertEquals((long)2L, (long)count[0]);
        notUpdated = Cayenne.objectForQuery(this.context, check);
        Assert.assertEquals((Object)new Long(0L), (Object)notUpdated);
    }
}

