/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.cayenne.Cayenne;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.EJBQLQuery;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.testdo.testmap.Painting;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class DataContextEJBQLConditionsIT
extends ServerCase {
    @Inject
    protected ObjectContext context;
    @Inject
    protected DBHelper dbHelper;
    protected TableHelper tArtist;
    protected TableHelper tPainting;

    @Before
    public void setUp() throws Exception {
        this.tArtist = new TableHelper(this.dbHelper, "ARTIST");
        this.tArtist.setColumns(new String[]{"ARTIST_ID", "ARTIST_NAME"});
        this.tPainting = new TableHelper(this.dbHelper, "PAINTING");
        this.tPainting.setColumns(new String[]{"PAINTING_ID", "ARTIST_ID", "PAINTING_TITLE", "ESTIMATED_PRICE"}).setColumnTypes(new int[]{4, -5, 12, 3});
    }

    protected void createCollectionDataSet() throws Exception {
        this.tArtist.insert(new Object[]{33001, "B"});
        this.tArtist.insert(new Object[]{33002, "A"});
        this.tArtist.insert(new Object[]{33003, "D"});
        this.tPainting.insert(new Object[]{33009, 33001, "X", 5000});
        this.tPainting.insert(new Object[]{33010, 33001, "Y", 5000});
        this.tPainting.insert(new Object[]{33011, 33002, "Z", 5000});
    }

    protected void createLikeDataSet() throws Exception {
        this.tPainting.insert(new Object[]{33001, null, "ABAAC", 3000});
        this.tPainting.insert(new Object[]{33002, null, "ADDDD", 4000});
        this.tPainting.insert(new Object[]{33003, null, "BDDDD", 5000});
        this.tPainting.insert(new Object[]{33004, null, "BBDDDD", 5000});
        this.tPainting.insert(new Object[]{33005, null, "_DDDD", 5000});
    }

    protected void createGreaterThanDataSet() throws Exception {
        this.createLikeDataSet();
    }

    protected void createInDataSet() throws Exception {
        this.tPainting.insert(new Object[]{33006, null, "A", 5000});
        this.tPainting.insert(new Object[]{33007, null, "B", 5000});
        this.tPainting.insert(new Object[]{33008, null, "C", 5000});
    }

    protected void createInSubqueryDataSet() throws Exception {
        this.tPainting.insert(new Object[]{33012, null, "C", 5000});
        this.tPainting.insert(new Object[]{33013, null, "D", 5000});
        this.tPainting.insert(new Object[]{33014, null, "C", 5000});
    }

    @Test
    public void testDateParameter() throws Exception {
        this.createCollectionDataSet();
        ObjectSelect<Artist> q = ObjectSelect.query(Artist.class);
        List allArtists = q.select(this.context);
        Date dob = new Date();
        ((Artist)allArtists.get(0)).setDateOfBirth(dob);
        this.context.commitChanges();
        String ejbql = "SELECT a FROM Artist a WHERE a.dateOfBirth = :x";
        EJBQLQuery query = new EJBQLQuery(ejbql);
        query.setParameter("x", (Object)dob);
        List objects = this.context.performQuery(query);
        Assert.assertEquals((long)1L, (long)objects.size());
        Assert.assertSame(allArtists.get(0), objects.get(0));
    }

    @Test
    public void testArithmetics() throws Exception {
        this.createLikeDataSet();
    }

    @Test
    public void testLike1() throws Exception {
        this.createLikeDataSet();
        String ejbql = "SELECT p FROM Painting p WHERE p.paintingTitle LIKE 'A%C'";
        EJBQLQuery query = new EJBQLQuery(ejbql);
        List objects = this.context.performQuery(query);
        Assert.assertEquals((long)1L, (long)objects.size());
        HashSet<Object> ids = new HashSet<Object>();
        Iterator it = objects.iterator();
        while (it.hasNext()) {
            Object id = Cayenne.pkForObject((Persistent)it.next());
            ids.add(id);
        }
        Assert.assertTrue((boolean)ids.contains(new Integer(33001)));
    }

    @Test
    public void testNotLike() throws Exception {
        this.createLikeDataSet();
        String ejbql = "SELECT p FROM Painting p WHERE p.paintingTitle NOT LIKE 'A%C'";
        EJBQLQuery query = new EJBQLQuery(ejbql);
        List objects = this.context.performQuery(query);
        Assert.assertEquals((long)4L, (long)objects.size());
        HashSet<Object> ids = new HashSet<Object>();
        Iterator it = objects.iterator();
        while (it.hasNext()) {
            Object id = Cayenne.pkForObject((Persistent)it.next());
            ids.add(id);
        }
        Assert.assertFalse((boolean)ids.contains(new Integer(33001)));
    }

    @Test
    public void testLike2() throws Exception {
        this.createLikeDataSet();
        String ejbql = "SELECT p FROM Painting p WHERE p.paintingTitle LIKE '_DDDD'";
        EJBQLQuery query = new EJBQLQuery(ejbql);
        List objects = this.context.performQuery(query);
        Assert.assertEquals((long)3L, (long)objects.size());
        HashSet<Object> ids = new HashSet<Object>();
        Iterator it = objects.iterator();
        while (it.hasNext()) {
            Object id = Cayenne.pkForObject((Persistent)it.next());
            ids.add(id);
        }
        Assert.assertTrue((boolean)ids.contains(new Integer(33002)));
        Assert.assertTrue((boolean)ids.contains(new Integer(33003)));
        Assert.assertTrue((boolean)ids.contains(new Integer(33005)));
    }

    @Test
    public void testLikeEscape() throws Exception {
        this.createLikeDataSet();
        String ejbql = "SELECT p FROM Painting p WHERE p.paintingTitle LIKE 'X_DDDD' ESCAPE 'X'";
        EJBQLQuery query = new EJBQLQuery(ejbql);
        List objects = this.context.performQuery(query);
        Assert.assertEquals((long)1L, (long)objects.size());
        HashSet<Object> ids = new HashSet<Object>();
        Iterator it = objects.iterator();
        while (it.hasNext()) {
            Object id = Cayenne.pkForObject((Persistent)it.next());
            ids.add(id);
        }
        Assert.assertTrue((boolean)ids.contains(new Integer(33005)));
    }

    @Test
    public void testLikeEscape_LikeParameter() throws Exception {
        this.createLikeDataSet();
        String ejbql = "SELECT p FROM Painting p WHERE p.paintingTitle LIKE ?1 ESCAPE 'X'";
        EJBQLQuery query = new EJBQLQuery(ejbql);
        query.setParameter(1, (Object)"X_DDDD");
        List objects = this.context.performQuery(query);
        Assert.assertEquals((long)1L, (long)objects.size());
        HashSet<Object> ids = new HashSet<Object>();
        Iterator it = objects.iterator();
        while (it.hasNext()) {
            Object id = Cayenne.pkForObject((Persistent)it.next());
            ids.add(id);
        }
        Assert.assertTrue((boolean)ids.contains(new Integer(33005)));
    }

    @Test
    public void testLikeNullParameter() {
        Artist a1 = this.context.newObject(Artist.class);
        a1.setArtistName("a1");
        a1.setDateOfBirth(null);
        this.context.commitChanges();
        EJBQLQuery eq1 = new EJBQLQuery("select a from Artist a where a.dateOfBirth like :param");
        eq1.setParameter("param", null);
        Assert.assertNotNull((Object)Cayenne.objectForQuery(this.context, eq1));
        EJBQLQuery eq2 = new EJBQLQuery("select a from Artist a where a.dateOfBirth like ?1");
        eq2.setParameter(1, null);
        Assert.assertNotNull((Object)Cayenne.objectForQuery(this.context, eq2));
    }

    @Test
    public void testIn() throws Exception {
        this.createInDataSet();
        String ejbql = "SELECT p FROM Painting p WHERE p.paintingTitle IN ('A', 'B')";
        EJBQLQuery query = new EJBQLQuery(ejbql);
        List objects = this.context.performQuery(query);
        Assert.assertEquals((long)2L, (long)objects.size());
        HashSet<Object> ids = new HashSet<Object>();
        Iterator it = objects.iterator();
        while (it.hasNext()) {
            Object id = Cayenne.pkForObject((Persistent)it.next());
            ids.add(id);
        }
        Assert.assertTrue((boolean)ids.contains(new Integer(33006)));
        Assert.assertTrue((boolean)ids.contains(new Integer(33007)));
    }

    @Test
    public void testNotIn() throws Exception {
        this.createInDataSet();
        String ejbql = "SELECT p FROM Painting p WHERE p.paintingTitle NOT IN ('A', 'B')";
        EJBQLQuery query = new EJBQLQuery(ejbql);
        List objects = this.context.performQuery(query);
        Assert.assertEquals((long)1L, (long)objects.size());
        HashSet<Object> ids = new HashSet<Object>();
        Iterator it = objects.iterator();
        while (it.hasNext()) {
            Object id = Cayenne.pkForObject((Persistent)it.next());
            ids.add(id);
        }
        Assert.assertTrue((boolean)ids.contains(new Integer(33008)));
    }

    @Test
    public void testInSubquery() throws Exception {
        this.createInSubqueryDataSet();
        String ejbql = "SELECT p FROM Painting p WHERE p.paintingTitle IN (SELECT p1.paintingTitle FROM Painting p1 WHERE p1.paintingTitle = 'C')";
        EJBQLQuery query = new EJBQLQuery(ejbql);
        List objects = this.context.performQuery(query);
        Assert.assertEquals((long)2L, (long)objects.size());
        HashSet<Object> ids = new HashSet<Object>();
        Iterator it = objects.iterator();
        while (it.hasNext()) {
            Object id = Cayenne.pkForObject((Persistent)it.next());
            ids.add(id);
        }
        Assert.assertTrue((boolean)ids.contains(new Integer(33012)));
        Assert.assertTrue((boolean)ids.contains(new Integer(33014)));
    }

    @Test
    public void testCollectionEmpty() throws Exception {
        this.createCollectionDataSet();
        String ejbql = "SELECT a FROM Artist a WHERE a.paintingArray IS EMPTY";
        EJBQLQuery query = new EJBQLQuery(ejbql);
        List objects = this.context.performQuery(query);
        Assert.assertEquals((long)1L, (long)objects.size());
        HashSet<Object> ids = new HashSet<Object>();
        Iterator it = objects.iterator();
        while (it.hasNext()) {
            Object id = Cayenne.pkForObject((Persistent)it.next());
            ids.add(id);
        }
        Assert.assertTrue((boolean)ids.contains(new Long(33003L)));
    }

    @Test
    public void testCollectionNotEmpty() throws Exception {
        this.createCollectionDataSet();
        String ejbql = "SELECT a FROM Artist a WHERE a.paintingArray IS NOT EMPTY";
        EJBQLQuery query = new EJBQLQuery(ejbql);
        List objects = this.context.performQuery(query);
        Assert.assertEquals((long)2L, (long)objects.size());
        HashSet<Object> ids = new HashSet<Object>();
        Iterator it = objects.iterator();
        while (it.hasNext()) {
            Object id = Cayenne.pkForObject((Persistent)it.next());
            ids.add(id);
        }
        Assert.assertTrue((boolean)ids.contains(33001L));
        Assert.assertTrue((boolean)ids.contains(33002L));
    }

    @Test
    public void testCollectionNotEmptyExplicitDistinct() throws Exception {
        this.createCollectionDataSet();
        String ejbql = "SELECT DISTINCT a FROM Artist a WHERE a.paintingArray IS NOT EMPTY";
        EJBQLQuery query = new EJBQLQuery(ejbql);
        List objects = this.context.performQuery(query);
        Assert.assertEquals((long)2L, (long)objects.size());
        HashSet<Object> ids = new HashSet<Object>();
        Iterator it = objects.iterator();
        while (it.hasNext()) {
            Object id = Cayenne.pkForObject((Persistent)it.next());
            ids.add(id);
        }
        Assert.assertTrue((boolean)ids.contains(33001L));
        Assert.assertTrue((boolean)ids.contains(33002L));
    }

    @Test
    public void testCollectionMemberOfParameter() throws Exception {
        this.createCollectionDataSet();
        String ejbql = "SELECT a FROM Artist a WHERE :x MEMBER OF a.paintingArray";
        EJBQLQuery query = new EJBQLQuery(ejbql);
        query.setParameter("x", (Object)Cayenne.objectForPK(this.context, Painting.class, 33010));
        List objects = this.context.performQuery(query);
        Assert.assertEquals((long)1L, (long)objects.size());
        HashSet<Object> ids = new HashSet<Object>();
        Iterator it = objects.iterator();
        while (it.hasNext()) {
            Object id = Cayenne.pkForObject((Persistent)it.next());
            ids.add(id);
        }
        Assert.assertTrue((boolean)ids.contains(33001L));
    }

    @Test
    public void testGreaterOrEquals() throws Exception {
        this.createGreaterThanDataSet();
        String ejbql = "SELECT p FROM Painting p WHERE p.estimatedPrice >= :estimatedPrice";
        EJBQLQuery query = new EJBQLQuery(ejbql);
        query.setParameter("estimatedPrice", (Object)new BigDecimal(4000));
        List objects = this.context.performQuery(query);
        Assert.assertEquals((long)4L, (long)objects.size());
    }

    @Test
    public void testLessOrEquals() throws Exception {
        this.createGreaterThanDataSet();
        String ejbql = "SELECT p FROM Painting p WHERE p.estimatedPrice <= :estimatedPrice";
        EJBQLQuery query = new EJBQLQuery(ejbql);
        query.setParameter("estimatedPrice", (Object)new BigDecimal(4000));
        List objects = this.context.performQuery(query);
        Assert.assertEquals((long)2L, (long)objects.size());
    }

    @Test
    public void testCollectionNotMemberOfParameter() throws Exception {
        this.createCollectionDataSet();
        String ejbql = "SELECT a FROM Artist a WHERE :x NOT MEMBER a.paintingArray";
        EJBQLQuery query = new EJBQLQuery(ejbql);
        query.setParameter("x", (Object)Cayenne.objectForPK(this.context, Painting.class, 33010));
        List objects = this.context.performQuery(query);
        Assert.assertEquals((long)2L, (long)objects.size());
        HashSet<Object> ids = new HashSet<Object>();
        Iterator it = objects.iterator();
        while (it.hasNext()) {
            Object id = Cayenne.pkForObject((Persistent)it.next());
            ids.add(id);
        }
        Assert.assertTrue((boolean)ids.contains(33002L));
        Assert.assertTrue((boolean)ids.contains(33003L));
    }

    @Test
    public void testCollectionMemberOfThetaJoin() throws Exception {
        this.createCollectionDataSet();
        String ejbql = "SELECT p FROM Painting p, Artist a WHERE p MEMBER OF a.paintingArray AND a.artistName = 'B'";
        EJBQLQuery query = new EJBQLQuery(ejbql);
        List objects = this.context.performQuery(query);
        Assert.assertEquals((long)2L, (long)objects.size());
        HashSet<Object> ids = new HashSet<Object>();
        Iterator it = objects.iterator();
        while (it.hasNext()) {
            Object id = Cayenne.pkForObject((Persistent)it.next());
            ids.add(id);
        }
        Assert.assertTrue((boolean)ids.contains(new Integer(33009)));
        Assert.assertTrue((boolean)ids.contains(new Integer(33010)));
    }
}

