/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.cayenne.ValueHolder;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.query.SortOrder;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.testdo.testmap.Painting;
import org.apache.cayenne.testdo.testmap.PaintingInfo;
import org.apache.cayenne.unit.di.DataChannelInterceptor;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class DataContextDisjointByIdPrefetchIT
extends ServerCase {
    @Inject
    protected DataContext context;
    @Inject
    protected DBHelper dbHelper;
    @Inject
    protected DataChannelInterceptor queryInterceptor;
    private TableHelper tArtist;
    private TableHelper tPainting;
    private TableHelper tPaintingInfo;

    @Before
    public void setUp() throws Exception {
        this.tArtist = new TableHelper(this.dbHelper, "ARTIST");
        this.tArtist.setColumns(new String[]{"ARTIST_ID", "ARTIST_NAME"});
        this.tPainting = new TableHelper(this.dbHelper, "PAINTING");
        this.tPainting.setColumns(new String[]{"PAINTING_ID", "ARTIST_ID", "PAINTING_TITLE"}).setColumnTypes(new int[]{4, -5, 12});
        this.tPaintingInfo = new TableHelper(this.dbHelper, "PAINTING_INFO");
        this.tPaintingInfo.setColumns(new String[]{"PAINTING_ID", "TEXT_REVIEW"});
    }

    private void createArtistWithTwoPaintingsDataSet() throws Exception {
        this.tArtist.insert(new Object[]{1, "X"});
        for (int i = 1; i <= 2; ++i) {
            this.tPainting.insert(new Object[]{i, 1, "Y" + i});
        }
    }

    private void createThreeArtistsWithPlentyOfPaintingsDataSet() throws Exception {
        this.tArtist.insert(new Object[]{1, "bag1"});
        this.tArtist.insert(new Object[]{2, "bag2"});
        this.tArtist.insert(new Object[]{3, "bag3"});
        this.tPainting.insert(new Object[]{1, 1, "box1"});
        this.tPainting.insert(new Object[]{2, 1, "box2"});
        this.tPainting.insert(new Object[]{3, 1, "box3"});
        this.tPainting.insert(new Object[]{4, 1, "box4"});
        this.tPainting.insert(new Object[]{5, 1, "box5"});
        this.tPainting.insert(new Object[]{6, 2, "box6"});
        this.tPainting.insert(new Object[]{7, 2, "box7"});
        this.tPainting.insert(new Object[]{8, 3, "box8"});
        this.tPainting.insert(new Object[]{9, 3, "box9"});
        this.tPainting.insert(new Object[]{10, 3, "box10"});
    }

    private void createTwoPaintingsWithInfosDataSet() throws Exception {
        this.tArtist.insert(new Object[]{1, "bag1"});
        this.tPainting.insert(new Object[]{1, 1, "big"});
        this.tPaintingInfo.insert(new Object[]{1, "red"});
        this.tPainting.insert(new Object[]{2, 1, "small"});
        this.tPaintingInfo.insert(new Object[]{2, "green"});
    }

    @Test
    public void testOneToMany() throws Exception {
        this.createArtistWithTwoPaintingsDataSet();
        List result = ObjectSelect.query(Artist.class).prefetch(Artist.PAINTING_ARRAY.disjointById()).select(this.context);
        this.queryInterceptor.runWithQueriesBlocked(() -> {
            Assert.assertFalse((boolean)result.isEmpty());
            Artist b1 = (Artist)result.get(0);
            List toMany = (List)b1.readPropertyDirectly(Artist.PAINTING_ARRAY.getName());
            Assert.assertNotNull((Object)toMany);
            Assert.assertFalse((boolean)((ValueHolder)((Object)toMany)).isFault());
            Assert.assertEquals((long)2L, (long)toMany.size());
            ArrayList<String> names = new ArrayList<String>();
            for (Painting b : toMany) {
                Assert.assertEquals((long)3L, (long)b.getPersistenceState());
                names.add(b.getPaintingTitle());
            }
            Assert.assertTrue((boolean)names.contains("Y1"));
            Assert.assertTrue((boolean)names.contains("Y2"));
        });
    }

    @Test
    public void testManyToOne() throws Exception {
        this.createArtistWithTwoPaintingsDataSet();
        List result = ObjectSelect.query(Painting.class).prefetch(Painting.TO_ARTIST.disjointById()).select(this.context);
        this.queryInterceptor.runWithQueriesBlocked(() -> {
            Assert.assertFalse((boolean)result.isEmpty());
            Painting b1 = (Painting)result.get(0);
            Assert.assertNotNull((Object)b1.getToArtist());
            Assert.assertEquals((long)3L, (long)b1.getToArtist().getPersistenceState());
            Assert.assertEquals((Object)"X", (Object)b1.getToArtist().getArtistName());
        });
    }

    @Test
    public void testFetchLimit() throws Exception {
        this.createThreeArtistsWithPlentyOfPaintingsDataSet();
        List bags = ObjectSelect.query(Artist.class).prefetch(Artist.PAINTING_ARRAY.disjointById()).orderBy("db:ARTIST_ID", SortOrder.ASCENDING).limit(2).select(this.context);
        this.queryInterceptor.runWithQueriesBlocked(() -> {
            Assert.assertEquals((long)2L, (long)bags.size());
            Assert.assertEquals((long)5L, (long)((Artist)bags.get(0)).getPaintingArray().size());
            Assert.assertEquals((long)2L, (long)((Artist)bags.get(1)).getPaintingArray().size());
            for (Artist b : bags) {
                b.getArtistName();
                for (Painting bx : b.getPaintingArray()) {
                    bx.getPaintingTitle();
                }
            }
        });
    }

    @Test
    public void testOneToOneRelationship() throws Exception {
        this.createTwoPaintingsWithInfosDataSet();
        List result = ObjectSelect.query(Painting.class).prefetch(Painting.TO_PAINTING_INFO.disjointById()).select(this.context);
        this.queryInterceptor.runWithQueriesBlocked(() -> {
            Assert.assertFalse((boolean)result.isEmpty());
            ArrayList<String> boxColors = new ArrayList<String>();
            for (Painting box : result) {
                PaintingInfo info = (PaintingInfo)box.readPropertyDirectly(Painting.TO_PAINTING_INFO.getName());
                Assert.assertNotNull((Object)info);
                boxColors.add(info.getTextReview());
                Assert.assertEquals((long)3L, (long)info.getPersistenceState());
            }
            Assert.assertTrue((boolean)boxColors.containsAll(Arrays.asList("red", "green")));
        });
    }
}

