/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne;

import java.util.ArrayList;
import java.util.Map;
import org.apache.cayenne.Cayenne;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.map_to_many.MapToMany;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-map-to-many.xml")
public class CayenneDataObjectSetToManyMapIT
extends ServerCase {
    @Inject
    protected ObjectContext context;
    @Inject
    protected DBHelper dbHelper;
    protected TableHelper tMapToMany;
    protected TableHelper tMapToManyTarget;
    protected TableHelper tIdMapToMany;
    protected TableHelper tIdMapToManyTarget;

    @Before
    public void setUp() throws Exception {
        this.tMapToMany = new TableHelper(this.dbHelper, "MAP_TO_MANY");
        this.tMapToMany.setColumns(new String[]{"ID"});
        this.tMapToManyTarget = new TableHelper(this.dbHelper, "MAP_TO_MANY_TARGET");
        this.tMapToManyTarget.setColumns(new String[]{"ID", "MAP_TO_MANY_ID", "NAME"});
        this.tIdMapToMany = new TableHelper(this.dbHelper, "ID_MAP_TO_MANY");
        this.tIdMapToMany.setColumns(new String[]{"ID"});
        this.tIdMapToManyTarget = new TableHelper(this.dbHelper, "ID_MAP_TO_MANY_TARGET");
        this.tIdMapToManyTarget.setColumns(new String[]{"ID", "MAP_TO_MANY_ID"});
        this.createTestDataSet();
    }

    protected void createTestDataSet() throws Exception {
        this.tMapToMany.insert(new Object[]{1});
        this.tMapToMany.insert(new Object[]{2});
        this.tMapToManyTarget.insert(new Object[]{1, 1, "A"});
        this.tMapToManyTarget.insert(new Object[]{2, 1, "B"});
        this.tMapToManyTarget.insert(new Object[]{3, 1, "C"});
        this.tMapToManyTarget.insert(new Object[]{4, 2, "A"});
    }

    @Test
    public void testRelationCollectionTypeMap() {
        MapToMany o1 = Cayenne.objectForPK(this.context, MapToMany.class, 1);
        Assert.assertTrue((boolean)(o1.readProperty(MapToMany.TARGETS.getName()) instanceof Map));
        try {
            o1.setToManyTarget(MapToMany.TARGETS.getName(), new ArrayList(0), true);
        }
        catch (RuntimeException e) {
            Assert.fail();
        }
        Assert.assertEquals((float)0.0f, (float)o1.getTargets().size(), (float)0.0f);
    }
}

