/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.unit.di.server;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.cayenne.conn.DataSourceInfo;

class ConnectionProperties {
    static final int MIN_CONNECTIONS = 1;
    static final int MAX_CONNECTIONS = 3;
    private static final String ADAPTER_KEY = "adapter";
    private static final String ADAPTER20_KEY = "cayenne.adapter";
    private static final String USER_NAME_KEY = "jdbc.username";
    private static final String PASSWORD_KEY = "jdbc.password";
    private static final String URL_KEY = "jdbc.url";
    private static final String DRIVER_KEY = "jdbc.driver";
    private Map<String, DataSourceInfo> connectionInfos = new HashMap<String, DataSourceInfo>();

    ConnectionProperties(Map<String, String> props) {
        for (String name : this.extractNames(props)) {
            DataSourceInfo dsi = this.buildDataSourceInfo(props.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(name + '.')).collect(Collectors.toMap(e -> {
                String key = (String)e.getKey();
                return key.substring(key.indexOf(46) + 1);
            }, Map.Entry::getValue)));
            this.connectionInfos.put(name, dsi);
        }
    }

    int size() {
        return this.connectionInfos.size();
    }

    DataSourceInfo getConnection(String name) {
        return this.connectionInfos.get(name);
    }

    private DataSourceInfo buildDataSourceInfo(Map<String, String> props) {
        DataSourceInfo dsi = new DataSourceInfo();
        String adapter = props.get(ADAPTER_KEY);
        if (adapter == null) {
            adapter = props.get(ADAPTER20_KEY);
        }
        dsi.setAdapterClassName(adapter);
        dsi.setUserName(props.get(USER_NAME_KEY));
        dsi.setPassword(props.get(PASSWORD_KEY));
        dsi.setDataSourceUrl(props.get(URL_KEY));
        dsi.setJdbcDriver(props.get(DRIVER_KEY));
        dsi.setMinConnections(1);
        dsi.setMaxConnections(3);
        return dsi;
    }

    private List<String> extractNames(Map<String, String> props) {
        Iterator<String> it = props.keySet().iterator();
        ArrayList<String> list = new ArrayList<String>();
        while (it.hasNext()) {
            String name;
            String key = it.next();
            int dotInd = key.indexOf(46);
            if (dotInd <= 0 || dotInd >= key.length() || list.contains(name = key.substring(0, dotInd))) continue;
            list.add(name);
        }
        return list;
    }
}

