/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.tx;

import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.configuration.server.ServerRuntime;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.testdo.testmap.Painting;
import org.apache.cayenne.tx.TransactionDescriptor;
import org.apache.cayenne.tx.TransactionManager;
import org.apache.cayenne.tx.TransactionPropagation;
import org.apache.cayenne.unit.UnitDbAdapter;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class TransactionPropagationRollbackIT
extends ServerCase {
    @Inject
    DataContext context;
    @Inject
    ServerRuntime runtime;
    @Inject
    UnitDbAdapter unitDbAdapter;
    TransactionManager manager;

    @Before
    public void initTransactionManager() {
        this.manager = (TransactionManager)this.runtime.getInjector().getInstance(TransactionManager.class);
    }

    @Test
    public void testPropagationRequiresNew() {
        TransactionDescriptor descriptor = TransactionDescriptor.builder().propagation(TransactionPropagation.REQUIRES_NEW).isolation(8).build();
        this.performInTransaction(descriptor);
        Assert.assertEquals((long)0L, (long)ObjectSelect.query(Artist.class).selectCount(this.context));
        Assert.assertEquals((long)1L, (long)ObjectSelect.query(Painting.class).selectCount(this.context));
    }

    @Test
    public void testPropagationNested() {
        TransactionDescriptor descriptor = TransactionDescriptor.builder().isolation(8).propagation(TransactionPropagation.NESTED).build();
        this.performInTransaction(descriptor);
        Assert.assertEquals((long)1L, (long)ObjectSelect.query(Artist.class).selectCount(this.context));
        Assert.assertEquals((long)1L, (long)ObjectSelect.query(Painting.class).selectCount(this.context));
    }

    @Test
    public void testPropagationMandatory() {
        TransactionDescriptor descriptor = TransactionDescriptor.builder().isolation(8).propagation(TransactionPropagation.MANDATORY).build();
        this.performInTransaction(descriptor);
        Assert.assertEquals((long)1L, (long)ObjectSelect.query(Artist.class).selectCount(this.context));
        Assert.assertEquals((long)1L, (long)ObjectSelect.query(Painting.class).selectCount(this.context));
    }

    private void performInTransaction(TransactionDescriptor descriptor) {
        Artist artist = this.context.newObject(Artist.class);
        artist.setArtistName("test");
        this.manager.performInTransaction(() -> {
            try {
                this.manager.performInTransaction(() -> {
                    artist.setArtistName("test3");
                    this.context.commitChanges();
                    artist.setArtistName(null);
                    this.context.commitChanges();
                    return null;
                }, descriptor);
                Assert.fail((String)"Exception should be thrown");
            }
            catch (Exception exception) {
                // empty catch block
            }
            artist.setArtistName("test2");
            Painting painting = this.context.newObject(Painting.class);
            painting.setPaintingTitle("painting");
            this.context.commitChanges();
            return null;
        });
    }
}

