/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.template.directive;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.MockOperationObserver;
import org.apache.cayenne.dba.JdbcAdapter;
import org.apache.cayenne.dba.oracle.OracleAdapter;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.log.JdbcEventLogger;
import org.apache.cayenne.query.CapsStrategy;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.query.SQLTemplate;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class BindDirectiveIT
extends ServerCase {
    private static String INSERT_TEMPLATE = "INSERT INTO ARTIST (ARTIST_ID, ARTIST_NAME, DATE_OF_BIRTH) VALUES (#bind($id), #bind($name), #bind($dob))";
    private static String INSERT_TEMPLATE_WITH_TYPES = "INSERT INTO ARTIST (ARTIST_ID, ARTIST_NAME, DATE_OF_BIRTH) VALUES (#bind($id), #bind($name), #bind($dob 'DATE'))";
    @Inject
    private JdbcAdapter adapter;
    @Inject
    private ObjectContext context;
    @Inject
    private JdbcEventLogger logger;
    @Inject
    private DataNode node;
    @Inject
    private DBHelper dbHelper;

    @Test
    public void testBind_Timestamp() throws Exception {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("id", new Integer(1));
        parameters.put("name", "ArtistWithDOB");
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(2010, 2, 8);
        parameters.put("dob", new Timestamp(cal.getTime().getTime()));
        Map<String, ?> row = this.performInsertForParameters(parameters, INSERT_TEMPLATE);
        Assert.assertEquals(parameters.get("name"), row.get("ARTIST_NAME"));
        Assert.assertEquals((Object)cal.getTime(), row.get("DATE_OF_BIRTH"));
        Assert.assertNotNull(row.get("DATE_OF_BIRTH"));
        Assert.assertEquals(java.util.Date.class, row.get("DATE_OF_BIRTH").getClass());
    }

    @Test
    public void testBind_SQLDate() throws Exception {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("id", new Integer(1));
        parameters.put("name", "ArtistWithDOB");
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(2010, 2, 8);
        parameters.put("dob", new Date(cal.getTime().getTime()));
        Map<String, ?> row = this.performInsertForParameters(parameters, INSERT_TEMPLATE);
        Assert.assertEquals(parameters.get("name"), row.get("ARTIST_NAME"));
        Assert.assertEquals(parameters.get("dob"), row.get("DATE_OF_BIRTH"));
        Assert.assertNotNull(row.get("DATE_OF_BIRTH"));
        Assert.assertEquals(java.util.Date.class, row.get("DATE_OF_BIRTH").getClass());
    }

    @Test
    public void testBind_UtilDate() throws Exception {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("id", new Integer(1));
        parameters.put("name", "ArtistWithDOB");
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(2010, 2, 8);
        parameters.put("dob", cal.getTime());
        Map<String, ?> row = this.performInsertForParameters(parameters, INSERT_TEMPLATE);
        Assert.assertEquals(parameters.get("name"), row.get("ARTIST_NAME"));
        Assert.assertEquals(parameters.get("dob"), row.get("DATE_OF_BIRTH"));
        Assert.assertNotNull(row.get("DATE_OF_BIRTH"));
        Assert.assertEquals(java.util.Date.class, row.get("DATE_OF_BIRTH").getClass());
    }

    @Test
    public void testBind_Collection() throws Exception {
        TableHelper tArtist = new TableHelper(this.dbHelper, "ARTIST").setColumns(new String[]{"ARTIST_ID", "ARTIST_NAME"});
        for (int i = 1; i < 4; ++i) {
            tArtist.insert(new Object[]{new Long(i), "Artist" + i});
        }
        HashSet<String> artistNames = new HashSet<String>();
        artistNames.add("Artist1");
        artistNames.add("Artist3");
        String sql = "SELECT * FROM ARTIST WHERE ARTIST_NAME in (#bind($ARTISTNAMES))";
        SQLTemplate query = new SQLTemplate(Artist.class, sql);
        query.setTemplate(OracleAdapter.class.getName(), "SELECT * FROM ARTIST WHERE RTRIM(ARTIST_NAME) in (#bind($ARTISTNAMES))");
        query.setColumnNamesCapitalization(CapsStrategy.UPPER);
        query.setParams(Collections.singletonMap("ARTISTNAMES", artistNames));
        List result = this.context.performQuery(query);
        Assert.assertEquals((long)2L, (long)result.size());
    }

    @Test
    public void testBind_NullParam() throws Exception {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("id", new Long(1L));
        parameters.put("name", "ArtistWithoutDOB");
        parameters.put("dob", null);
        Map<String, ?> row = this.performInsertForParameters(parameters, INSERT_TEMPLATE);
        Assert.assertEquals(parameters.get("id"), row.get("ARTIST_ID"));
        Assert.assertEquals(parameters.get("name"), row.get("ARTIST_NAME"));
        Assert.assertEquals(parameters.get("dob"), row.get("DATE_OF_BIRTH"));
        Assert.assertNull(row.get("DATE_OF_BIRTH"));
    }

    @Test
    public void testBind_NullParam_JDBCTypes() throws Exception {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("id", new Long(1L));
        parameters.put("name", "ArtistWithoutDOB");
        parameters.put("dob", null);
        Map<String, ?> row = this.performInsertForParameters(parameters, INSERT_TEMPLATE_WITH_TYPES);
        Assert.assertEquals(parameters.get("id"), row.get("ARTIST_ID"));
        Assert.assertEquals(parameters.get("name"), row.get("ARTIST_NAME"));
        Assert.assertEquals(parameters.get("dob"), row.get("DATE_OF_BIRTH"));
        Assert.assertNull(row.get("DATE_OF_BIRTH"));
    }

    @Test
    public void testBind_SkippedParam() throws Exception {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("id", new Long(1L));
        parameters.put("name", "ArtistWithoutDOB");
        Map<String, ?> row = this.performInsertForParameters(parameters, INSERT_TEMPLATE);
        Assert.assertEquals(parameters.get("id"), row.get("ARTIST_ID"));
        Assert.assertEquals(parameters.get("name"), row.get("ARTIST_NAME"));
        Assert.assertNull(row.get("DATE_OF_BIRTH"));
    }

    @Test
    public void testBind_SkippedParam_JDBCTypes() throws Exception {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("id", new Long(1L));
        parameters.put("name", "ArtistWithoutDOB");
        Map<String, ?> row = this.performInsertForParameters(parameters, INSERT_TEMPLATE_WITH_TYPES);
        Assert.assertEquals(parameters.get("id"), row.get("ARTIST_ID"));
        Assert.assertEquals(parameters.get("name"), row.get("ARTIST_NAME"));
        Assert.assertNull(row.get("DATE_OF_BIRTH"));
    }

    private Map<String, ?> performInsertForParameters(Map<String, Object> parameters, String templateString) throws Exception {
        SQLTemplate template = new SQLTemplate(Object.class, templateString);
        template.setParams(parameters);
        MockOperationObserver observer = new MockOperationObserver();
        this.node.performQueries(Collections.singletonList(template), observer);
        return (Map)ObjectSelect.dataRowQuery(Artist.class).selectOne(this.context);
    }
}

