/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.reflect;

import org.apache.cayenne.reflect.BeanAccessor;
import org.apache.cayenne.reflect.TstJavaBean;
import org.apache.cayenne.reflect.TstJavaBeanChild;
import org.junit.Assert;
import org.junit.Test;

public class BeanAccessorTest {
    @Test
    public void testByteArrayProperty() {
        BeanAccessor accessor = new BeanAccessor(TstJavaBean.class, "byteArrayField", byte[].class);
        byte[] bytes = new byte[]{5, 6, 7};
        TstJavaBean o1 = new TstJavaBean();
        Assert.assertNull((Object)o1.getByteArrayField());
        accessor.setValue(o1, bytes);
        Assert.assertSame((Object)bytes, (Object)o1.getByteArrayField());
        Assert.assertSame((Object)bytes, (Object)accessor.getValue(o1));
    }

    @Test
    public void testStringProperty() {
        BeanAccessor accessor = new BeanAccessor(TstJavaBean.class, "stringField", String.class);
        TstJavaBean o1 = new TstJavaBean();
        Assert.assertNull((Object)o1.getStringField());
        accessor.setValue(o1, "ABC");
        Assert.assertSame((Object)"ABC", (Object)o1.getStringField());
        Assert.assertSame((Object)"ABC", (Object)accessor.getValue(o1));
    }

    @Test
    public void testIntProperty() {
        BeanAccessor accessor = new BeanAccessor(TstJavaBean.class, "intField", Integer.TYPE);
        TstJavaBean o1 = new TstJavaBean();
        Assert.assertEquals((long)0L, (long)o1.getIntField());
        accessor.setValue(o1, new Integer(5));
        Assert.assertEquals((long)5L, (long)o1.getIntField());
        Assert.assertEquals((Object)new Integer(5), (Object)accessor.getValue(o1));
        accessor.setValue(o1, null);
        Assert.assertEquals((String)"Incorrectly set null default", (long)0L, (long)o1.getIntField());
    }

    @Test
    public void testInheritedCovariantProperty() {
        BeanAccessor accessor = new BeanAccessor(TstJavaBeanChild.class, "related", null);
        TstJavaBeanChild o1 = new TstJavaBeanChild();
        Assert.assertNull((Object)o1.getRelated());
        accessor.setValue(o1, o1);
        Assert.assertSame((Object)o1, (Object)o1.getRelated());
        Assert.assertSame((Object)o1, (Object)accessor.getValue(o1));
    }
}

