/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import org.apache.cayenne.DataRow;
import org.apache.cayenne.configuration.server.ServerRuntime;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.query.QueryChain;
import org.apache.cayenne.query.QueryMetadata;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class QueryChainIT
extends ServerCase {
    @Inject
    private ServerRuntime runtime;

    @Test
    public void testSelectQuery() {
        QueryChain chain = new QueryChain();
        chain.addQuery(ObjectSelect.query(Artist.class));
        chain.addQuery(ObjectSelect.query(Artist.class));
        QueryMetadata md = chain.getMetaData(this.runtime.getDataDomain().getEntityResolver());
        Assert.assertNotNull((Object)md);
        Assert.assertTrue((boolean)md.isFetchingDataRows());
        Assert.assertNull((Object)md.getObjEntity());
    }

    @Test
    public void testSelectQueryDataRows() {
        QueryChain chain = new QueryChain();
        ObjectSelect<DataRow> q1 = ObjectSelect.dataRowQuery(Artist.class);
        chain.addQuery(q1);
        ObjectSelect<DataRow> q2 = ObjectSelect.dataRowQuery(Artist.class);
        chain.addQuery(q2);
        QueryMetadata md = chain.getMetaData(this.runtime.getDataDomain().getEntityResolver());
        Assert.assertNotNull((Object)md);
        Assert.assertTrue((boolean)md.isFetchingDataRows());
        Assert.assertNull((Object)md.getObjEntity());
    }
}

