/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.map;

import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.QueryDescriptor;
import org.apache.cayenne.map.SelectQueryDescriptor;
import org.apache.cayenne.query.AbstractQuery;
import org.apache.cayenne.query.FluentSelect;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.query.Query;
import org.junit.Assert;
import org.junit.Test;

public class SelectQueryDescriptorTest {
    @Test
    public void testGetQueryType() {
        SelectQueryDescriptor builder = QueryDescriptor.selectQueryDescriptor();
        builder.setRoot("FakeRoot");
        Assert.assertTrue((boolean)(builder.buildQuery() instanceof ObjectSelect));
    }

    @Test
    public void testGetQueryRoot() {
        DataMap map = new DataMap();
        ObjEntity entity = new ObjEntity("A");
        map.addObjEntity(entity);
        SelectQueryDescriptor builder = QueryDescriptor.selectQueryDescriptor();
        builder.setRoot(entity);
        Assert.assertTrue((boolean)(builder.buildQuery() instanceof ObjectSelect));
        Assert.assertSame((Object)entity, (Object)((AbstractQuery)builder.buildQuery()).getRoot());
    }

    @Test
    public void testGetQueryQualifier() {
        SelectQueryDescriptor builder = QueryDescriptor.selectQueryDescriptor();
        builder.setRoot("FakeRoot");
        builder.setQualifier(ExpressionFactory.exp("abc = 5", new Object[0]));
        Query query = builder.buildQuery();
        Assert.assertEquals((Object)ExpressionFactory.exp("abc = 5", new Object[0]), (Object)((FluentSelect)query).getWhere());
    }

    @Test
    public void testGetQueryProperties() {
        SelectQueryDescriptor builder = QueryDescriptor.selectQueryDescriptor();
        builder.setRoot("FakeRoot");
        builder.setProperty("cayenne.GenericSelectQuery.fetchLimit", "5");
        builder.setProperty("cayenne.GenericSelectQuery.statementFetchSize", "6");
        Query query = builder.buildQuery();
        Assert.assertTrue((boolean)(query instanceof ObjectSelect));
        Assert.assertEquals((long)5L, (long)((FluentSelect)query).getLimit());
        Assert.assertEquals((long)6L, (long)((FluentSelect)query).getStatementFetchSize());
    }
}

