/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.translator.select;

import org.apache.cayenne.access.translator.select.PathComponents;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PathComponentsTest {
    private PathComponents components1;
    private PathComponents components2;
    private PathComponents components3;

    @Before
    public void setUp() {
        this.components1 = new PathComponents("a");
        this.components2 = new PathComponents("a+.bcd");
        this.components3 = new PathComponents("a.bc.defg");
    }

    @Test
    public void size() {
        Assert.assertEquals((long)1L, (long)this.components1.size());
        Assert.assertEquals((long)2L, (long)this.components2.size());
        Assert.assertEquals((long)3L, (long)this.components3.size());
    }

    @Test
    public void getLast() {
        Assert.assertEquals((Object)"a", (Object)this.components1.getLast());
        Assert.assertEquals((Object)"bcd", (Object)this.components2.getLast());
        Assert.assertEquals((Object)"defg", (Object)this.components3.getLast());
    }

    @Test
    public void getParent() {
        Assert.assertEquals((Object)"", (Object)this.components1.getParent());
        Assert.assertEquals((Object)"a+", (Object)this.components2.getParent());
        Assert.assertEquals((Object)"a.bc", (Object)this.components3.getParent());
    }

    @Test
    public void getAll() {
        Assert.assertArrayEquals((Object[])new String[]{"a"}, (Object[])this.components1.getAll());
        Assert.assertArrayEquals((Object[])new String[]{"a+", "bcd"}, (Object[])this.components2.getAll());
        Assert.assertArrayEquals((Object[])new String[]{"a", "bc", "defg"}, (Object[])this.components3.getAll());
    }

    @Test
    public void getPath() {
        Assert.assertEquals((Object)"a", (Object)this.components1.getPath());
        Assert.assertEquals((Object)"a+.bcd", (Object)this.components2.getPath());
        Assert.assertEquals((Object)"a.bc.defg", (Object)this.components3.getPath());
    }
}

