/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.translator;

import org.apache.cayenne.access.types.ExtendedType;

public class ParameterBinding {
    private static final int EXCLUDED_POSITION = -1;
    private Object value;
    private int statementPosition;
    private ExtendedType extendedType;
    private Integer jdbcType;
    private int scale;

    public ParameterBinding(Object value, Integer jdbcType, int scale) {
        this.value = value;
        this.jdbcType = jdbcType;
        this.scale = scale;
    }

    public ParameterBinding() {
        this.statementPosition = -1;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public int getStatementPosition() {
        return this.statementPosition;
    }

    public void setStatementPosition(int statementPosition) {
        this.statementPosition = statementPosition;
    }

    public boolean isExcluded() {
        return this.statementPosition == -1;
    }

    public ExtendedType getExtendedType() {
        return this.extendedType;
    }

    public void setExtendedType(ExtendedType extendedType) {
        this.extendedType = extendedType;
    }

    public void exclude() {
        this.statementPosition = -1;
        this.value = null;
        this.extendedType = null;
    }

    public void include(int statementPosition, Object value, ExtendedType extendedType) {
        this.statementPosition = statementPosition;
        this.value = value;
        this.extendedType = extendedType;
    }

    public Integer getJdbcType() {
        return this.jdbcType;
    }

    public void setJdbcType(Integer type) {
        this.jdbcType = type;
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }
}

