/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.sql.Date;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.cayenne.DataObject;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.ValueHolder;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.configuration.server.ServerRuntime;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.query.SQLSelect;
import org.apache.cayenne.query.SQLTemplate;
import org.apache.cayenne.query.SortOrder;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.testdo.testmap.Painting;
import org.apache.cayenne.unit.di.DataChannelInterceptor;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class JointPrefetchIT
extends ServerCase {
    @Inject
    protected DataContext context;
    @Inject
    protected ServerRuntime runtime;
    @Inject
    protected DataChannelInterceptor queryInterceptor;
    @Inject
    protected DBHelper dbHelper;
    protected TableHelper tArtist;
    protected TableHelper tGallery;
    protected TableHelper tPainting;

    @Before
    public void setUp() throws Exception {
        this.tArtist = new TableHelper(this.dbHelper, "ARTIST");
        this.tArtist.setColumns(new String[]{"ARTIST_ID", "ARTIST_NAME"});
        this.tGallery = new TableHelper(this.dbHelper, "GALLERY");
        this.tGallery.setColumns(new String[]{"GALLERY_ID", "GALLERY_NAME"});
        this.tPainting = new TableHelper(this.dbHelper, "PAINTING");
        this.tPainting.setColumns(new String[]{"PAINTING_ID", "PAINTING_TITLE", "ARTIST_ID", "ESTIMATED_PRICE", "GALLERY_ID"});
    }

    private void createJointPrefetchDataSet() throws Exception {
        this.tGallery.insert(new Object[]{33001, "G1"});
        this.tGallery.insert(new Object[]{33002, "G2"});
        this.tArtist.insert(new Object[]{33001, "artist1"});
        this.tArtist.insert(new Object[]{33002, "artist2"});
        this.tArtist.insert(new Object[]{33003, "artist3"});
        this.tPainting.insert(new Object[]{33001, "P_artist11", 33001, 1000, 33001});
        this.tPainting.insert(new Object[]{33002, "P_artist12", 33001, 2000, 33001});
        this.tPainting.insert(new Object[]{33003, "P_artist21", 33002, 3000, 33002});
    }

    @Test
    public void testJointPrefetch_ToOne_FetchLimit() throws Exception {
        this.createJointPrefetchDataSet();
        List objects = ObjectSelect.query(Painting.class).limit(2).offset(0).orderBy("db:PAINTING_ID", SortOrder.ASCENDING).prefetch(Painting.TO_ARTIST.joint()).select(this.context);
        this.queryInterceptor.runWithQueriesBlocked(() -> {
            Assert.assertEquals((long)2L, (long)objects.size());
            for (Painting p : objects) {
                Artist target = p.getToArtist();
                Assert.assertNotNull((Object)target);
                Assert.assertEquals((long)3L, (long)target.getPersistenceState());
            }
        });
    }

    @Test
    public void testJointPrefetch_ToMany_FetchLimit() throws Exception {
        this.createJointPrefetchDataSet();
        List objects = ObjectSelect.query(Artist.class).limit(2).offset(0).orderBy(Artist.ARTIST_ID_PK_PROPERTY.asc()).prefetch(Artist.PAINTING_ARRAY.joint()).select(this.context);
        this.queryInterceptor.runWithQueriesBlocked(() -> {
            Assert.assertEquals((long)1L, (long)objects.size());
            for (Artist a : objects) {
                List<Painting> targets = a.getPaintingArray();
                Assert.assertNotNull(targets);
                for (Painting p : targets) {
                    Assert.assertEquals((long)3L, (long)p.getPersistenceState());
                }
            }
        });
    }

    @Test
    public void testJointPrefetchDataRows() throws Exception {
        this.createJointPrefetchDataSet();
        List rows = ObjectSelect.dataRowQuery(Painting.class).orderBy("db:PAINTING_ID", SortOrder.ASCENDING).prefetch(Painting.TO_ARTIST.joint()).select(this.context);
        this.queryInterceptor.runWithQueriesBlocked(() -> {
            Assert.assertEquals((long)3L, (long)rows.size());
            int rowWidth = this.context.getEntityResolver().getDbEntity("ARTIST").getAttributes().size() + this.context.getEntityResolver().getDbEntity("PAINTING").getAttributes().size();
            for (DataRow row : rows) {
                Assert.assertEquals((String)("" + row), (long)rowWidth, (long)row.size());
                Assert.assertTrue((String)(row + ""), (boolean)row.containsKey("PAINTING_ID"));
                Assert.assertTrue((String)(row + ""), (boolean)row.containsKey("ARTIST_ID"));
                Assert.assertTrue((String)(row + ""), (boolean)row.containsKey("GALLERY_ID"));
                Assert.assertTrue((String)(row + ""), (boolean)row.containsKey("PAINTING_TITLE"));
                Assert.assertTrue((String)(row + ""), (boolean)row.containsKey("ESTIMATED_PRICE"));
                Assert.assertTrue((String)(row + ""), (boolean)row.containsKey("toArtist.ARTIST_NAME"));
                Assert.assertTrue((String)(row + ""), (boolean)row.containsKey("toArtist.DATE_OF_BIRTH"));
            }
        });
    }

    @Test
    public void testJointPrefetchSQLTemplate() throws Exception {
        this.createJointPrefetchDataSet();
        SQLTemplate q = new SQLTemplate(Artist.class, "SELECT distinct #result('ESTIMATED_PRICE' 'BigDecimal' '' 'paintingArray.ESTIMATED_PRICE'), #result('PAINTING_TITLE' 'String' '' 'paintingArray.PAINTING_TITLE'), #result('GALLERY_ID' 'int' '' 'paintingArray.GALLERY_ID'), #result('PAINTING_ID' 'int' '' 'paintingArray.PAINTING_ID'), #result('ARTIST_NAME' 'String'), #result('DATE_OF_BIRTH' 'java.util.Date'), #result('t0.ARTIST_ID' 'int' '' 'ARTIST_ID') FROM ARTIST t0, PAINTING t1 WHERE t0.ARTIST_ID = t1.ARTIST_ID");
        q.addPrefetch(Artist.PAINTING_ARRAY.joint());
        q.setFetchingDataRows(false);
        List objects = this.context.performQuery(q);
        this.queryInterceptor.runWithQueriesBlocked(() -> {
            Assert.assertEquals((long)2L, (long)objects.size());
            for (Artist a : objects) {
                List<Painting> list = a.getPaintingArray();
                Assert.assertNotNull(list);
                Assert.assertFalse((boolean)((ValueHolder)((Object)list)).isFault());
                Assert.assertTrue((list.size() > 0 ? 1 : 0) != 0);
                for (Painting p : list) {
                    Assert.assertEquals((long)3L, (long)p.getPersistenceState());
                    Assert.assertNotNull((Object)p.getPaintingTitle());
                }
            }
        });
    }

    @Test
    public void testJointPrefetchToOne() throws Exception {
        this.createJointPrefetchDataSet();
        List objects = ObjectSelect.query(Painting.class).orderBy("db:PAINTING_ID", SortOrder.ASCENDING).prefetch(Painting.TO_ARTIST.joint()).select(this.context);
        this.queryInterceptor.runWithQueriesBlocked(() -> {
            Assert.assertEquals((long)3L, (long)objects.size());
            for (Painting p : objects) {
                Artist target = p.getToArtist();
                Assert.assertNotNull((Object)target);
                Assert.assertEquals((long)3L, (long)target.getPersistenceState());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJointPrefetchDataTypes() {
        SQLTemplate artistSQL = new SQLTemplate(Artist.class, "insert into ARTIST (ARTIST_ID, ARTIST_NAME, DATE_OF_BIRTH) values (33001, 'a1', #bind($date 'DATE'))");
        artistSQL.setParams(Collections.singletonMap("date", new Date(System.currentTimeMillis())));
        SQLTemplate paintingSQL = new SQLTemplate(Painting.class, "INSERT INTO PAINTING (PAINTING_ID, PAINTING_TITLE, ARTIST_ID, ESTIMATED_PRICE) VALUES (33001, 'p1', 33001, 1000)");
        this.context.performNonSelectingQuery(artistSQL);
        this.context.performNonSelectingQuery(paintingSQL);
        ObjEntity artistE = this.context.getEntityResolver().getObjEntity("Artist");
        ObjAttribute dateOfBirth = artistE.getAttribute("dateOfBirth");
        Assert.assertEquals((Object)"java.util.Date", (Object)dateOfBirth.getType());
        dateOfBirth.setType("java.sql.Date");
        try {
            List objects = ObjectSelect.query(Painting.class).prefetch(Painting.TO_ARTIST.joint()).select(this.context);
            this.queryInterceptor.runWithQueriesBlocked(() -> {
                Assert.assertEquals((long)1L, (long)objects.size());
                for (Painting p : objects) {
                    Artist a = p.getToArtist();
                    Assert.assertNotNull((Object)a);
                    Assert.assertNotNull((Object)a.getDateOfBirth());
                    Assert.assertTrue((String)a.getDateOfBirth().getClass().getName(), (boolean)Date.class.isAssignableFrom(a.getDateOfBirth().getClass()));
                }
            });
        }
        finally {
            dateOfBirth.setType("java.util.Date");
        }
    }

    @Test
    public void testJointPrefetchToMany() throws Exception {
        this.createJointPrefetchDataSet();
        List objects = ObjectSelect.query(Artist.class).prefetch(Artist.PAINTING_ARRAY.joint()).select(this.context);
        this.queryInterceptor.runWithQueriesBlocked(() -> {
            Assert.assertEquals((long)3L, (long)objects.size());
            for (Artist a : objects) {
                List<Painting> list = a.getPaintingArray();
                Assert.assertNotNull(list);
                Assert.assertFalse((boolean)((ValueHolder)((Object)list)).isFault());
                for (Painting p : list) {
                    Assert.assertEquals((long)3L, (long)p.getPersistenceState());
                    Assert.assertNotNull((Object)p.getPaintingTitle());
                }
            }
        });
    }

    @Test
    public void testJointPrefetchToManyNonConflictingQualifier() throws Exception {
        this.createJointPrefetchDataSet();
        List objects = ObjectSelect.query(Artist.class).where(Artist.ARTIST_NAME.eq("artist1")).prefetch(Artist.PAINTING_ARRAY.joint()).select(this.context);
        this.queryInterceptor.runWithQueriesBlocked(() -> {
            Assert.assertEquals((long)1L, (long)objects.size());
            Artist a = (Artist)objects.get(0);
            List<Painting> list = a.getPaintingArray();
            Assert.assertNotNull(list);
            Assert.assertFalse((boolean)((ValueHolder)((Object)list)).isFault());
            Assert.assertEquals((long)2L, (long)list.size());
            for (Painting p : list) {
                Assert.assertEquals((long)3L, (long)p.getPersistenceState());
                Assert.assertNotNull((Object)p.getPaintingTitle());
            }
            HashSet<Painting> s = new HashSet<Painting>(list);
            Assert.assertEquals((long)s.size(), (long)list.size());
        });
    }

    @Test
    public void testJointPrefetchMultiStep() throws Exception {
        this.createJointPrefetchDataSet();
        DataContext context = this.context;
        context.getObjectStore().objectMap = new HashMap<Object, Persistent>();
        DataObject g1 = (DataObject)context.getGraphManager().getNode(ObjectId.of("Gallery", "GALLERY_ID", 33001));
        Assert.assertNull((Object)g1);
        List objects = ObjectSelect.query(Artist.class).prefetch(Artist.PAINTING_ARRAY.dot(Painting.TO_GALLERY).joint()).select(context);
        this.queryInterceptor.runWithQueriesBlocked(() -> {
            Assert.assertEquals((long)3L, (long)objects.size());
            for (Artist a : objects) {
                ValueHolder list = (ValueHolder)((Object)a.getPaintingArray());
                Assert.assertNotNull((Object)list);
                Assert.assertTrue((boolean)list.isFault());
            }
            DataObject g11 = (DataObject)context.getGraphManager().getNode(ObjectId.of("Gallery", "GALLERY_ID", 33001));
            Assert.assertNotNull((Object)g11);
            Assert.assertEquals((long)3L, (long)g11.getPersistenceState());
            DataObject g2 = (DataObject)context.getGraphManager().getNode(ObjectId.of("Gallery", "GALLERY_ID", 33002));
            Assert.assertNotNull((Object)g2);
            Assert.assertEquals((long)3L, (long)g2.getPersistenceState());
        });
    }

    @Test
    public void testJointPrefetchSQLSelectToMany() throws Exception {
        this.createJointPrefetchDataSet();
        List<Artist> objects = SQLSelect.query(Artist.class, "SELECT #result('ESTIMATED_PRICE' 'BigDecimal' '' 'paintingArray.ESTIMATED_PRICE'), #result('PAINTING_TITLE' 'String' '' 'paintingArray.PAINTING_TITLE'), #result('GALLERY_ID' 'int' '' 'paintingArray.GALLERY_ID'), #result('PAINTING_ID' 'int' '' 'paintingArray.PAINTING_ID'), #result('ARTIST_NAME' 'String'), #result('DATE_OF_BIRTH' 'java.util.Date'), #result('t0.ARTIST_ID' 'int' '' 'ARTIST_ID') FROM ARTIST t0, PAINTING t1 WHERE t0.ARTIST_ID = t1.ARTIST_ID").addPrefetch(Artist.PAINTING_ARRAY.joint()).select(this.context);
        this.queryInterceptor.runWithQueriesBlocked(() -> {
            Assert.assertEquals((long)2L, (long)objects.size());
            for (Artist artist : objects) {
                List<Painting> paintings = artist.getPaintingArray();
                Assert.assertTrue((paintings.size() > 0 ? 1 : 0) != 0);
                for (Painting painting : paintings) {
                    Assert.assertEquals((long)3L, (long)painting.getPersistenceState());
                    Assert.assertNotNull((Object)painting.getPaintingTitle());
                }
            }
        });
    }

    @Test
    public void testJointPrefetchSQLSelectNestedJoint() throws Exception {
        this.createJointPrefetchDataSet();
        SQLSelect.query(Artist.class, "SELECT #result('GALLERY_ID' 'int' '' 'paintingArray.toGallery.GALLERY_ID'),#result('GALLERY_NAME' 'String' '' 'paintingArray.toGallery.GALLERY_NAME'),#result('t0.ARTIST_ID' 'int' '' 'ARTIST_ID') FROM ARTIST t0, GALLERY t2 ").addPrefetch(Artist.PAINTING_ARRAY.dot(Painting.TO_GALLERY).joint()).select(this.context);
        this.queryInterceptor.runWithQueriesBlocked(() -> {
            DataObject g1 = (DataObject)this.context.getGraphManager().getNode(ObjectId.of("Gallery", "GALLERY_ID", 33001));
            Assert.assertNotNull((Object)g1);
            Assert.assertEquals((Object)"G1", (Object)g1.readProperty("galleryName"));
        });
    }

    @Test
    @Ignore(value="Waiting for a fix, see CAY-2630")
    public void testJointPrefetchPreservesPendingToOneArcDiff() throws Exception {
        this.createJointPrefetchDataSet();
        Artist artist = ObjectSelect.query(Artist.class).where(Artist.ARTIST_NAME.eq("artist1")).selectFirst(this.context);
        Painting painting = ObjectSelect.query(Painting.class).where(Painting.PAINTING_TITLE.eq("P_artist21")).selectFirst(this.context);
        painting.setToArtist(artist);
        ObjectSelect.query(Painting.class).where(Painting.PAINTING_TITLE.eq("P_artist21")).selectFirst(this.context);
        Assert.assertEquals((Object)artist, (Object)painting.getToArtist());
        ObjectSelect.query(Artist.class).where(Artist.ARTIST_NAME.eq("artist1")).selectFirst(this.context);
        Assert.assertEquals((Object)artist, (Object)painting.getToArtist());
        ObjectSelect.query(Painting.class).where(Painting.PAINTING_TITLE.eq("P_artist21")).prefetch(Painting.TO_ARTIST.joint()).selectFirst(this.context);
        Assert.assertEquals((Object)artist, (Object)painting.getToArtist());
    }
}

