/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.sql.Timestamp;
import java.util.List;
import org.apache.cayenne.Cayenne;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.testdo.testmap.Gallery;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class DataContextJoinAliasesIT
extends ServerCase {
    @Inject
    ObjectContext context;
    @Inject
    DBHelper dbHelper;
    protected TableHelper tArtist;
    protected TableHelper tExhibit;
    protected TableHelper tGallery;
    protected TableHelper tArtistExhibit;

    @Before
    public void setUp() throws Exception {
        this.tArtist = new TableHelper(this.dbHelper, "ARTIST");
        this.tArtist.setColumns(new String[]{"ARTIST_ID", "ARTIST_NAME"});
        this.tExhibit = new TableHelper(this.dbHelper, "EXHIBIT");
        this.tExhibit.setColumns(new String[]{"EXHIBIT_ID", "GALLERY_ID", "OPENING_DATE", "CLOSING_DATE"});
        this.tGallery = new TableHelper(this.dbHelper, "GALLERY");
        this.tGallery.setColumns(new String[]{"GALLERY_ID", "GALLERY_NAME"});
        this.tArtistExhibit = new TableHelper(this.dbHelper, "ARTIST_EXHIBIT");
        this.tArtistExhibit.setColumns(new String[]{"EXHIBIT_ID", "ARTIST_ID"});
    }

    protected void createMatchAllDataSet() throws Exception {
        this.tArtist.insert(new Object[]{1, "Picasso"});
        this.tArtist.insert(new Object[]{2, "Dali"});
        this.tArtist.insert(new Object[]{3, "X"});
        this.tArtist.insert(new Object[]{4, "Y"});
        this.tGallery.insert(new Object[]{1, "G1"});
        this.tGallery.insert(new Object[]{2, "G2"});
        this.tGallery.insert(new Object[]{3, "G3"});
        Timestamp now = new Timestamp(System.currentTimeMillis());
        this.tExhibit.insert(new Object[]{1, 2, now, now});
        this.tExhibit.insert(new Object[]{2, 2, now, now});
        this.tExhibit.insert(new Object[]{3, 1, now, now});
        this.tExhibit.insert(new Object[]{4, 1, now, now});
        this.tExhibit.insert(new Object[]{5, 3, now, now});
        this.tArtistExhibit.insert(new Object[]{1, 1});
        this.tArtistExhibit.insert(new Object[]{1, 3});
        this.tArtistExhibit.insert(new Object[]{3, 1});
        this.tArtistExhibit.insert(new Object[]{4, 2});
        this.tArtistExhibit.insert(new Object[]{4, 4});
        this.tArtistExhibit.insert(new Object[]{5, 2});
    }

    @Test
    public void testMatchAll() throws Exception {
        this.createMatchAllDataSet();
        Artist picasso = Cayenne.objectForPK(this.context, Artist.class, 1);
        Artist dali = Cayenne.objectForPK(this.context, Artist.class, 2);
        List galleries = ObjectSelect.query(Gallery.class).where(ExpressionFactory.matchAllExp("|exhibitArray.artistExhibitArray.toArtist", picasso, dali)).select(this.context);
        Assert.assertEquals((long)1L, (long)galleries.size());
        Assert.assertEquals((Object)"G1", (Object)((Gallery)galleries.get(0)).getGalleryName());
    }
}

