/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import org.apache.cayenne.Cayenne;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.QueryResponse;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.EJBQLQuery;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.numeric_types.BigDecimalEntity;
import org.apache.cayenne.testdo.numeric_types.BigIntegerEntity;
import org.apache.cayenne.testdo.numeric_types.BooleanTestEntity;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-numeric-types.xml")
public class DataContextEJBQLNumericalFunctionalIT
extends ServerCase {
    @Inject
    protected DBHelper dbHelper;
    @Inject
    private ObjectContext context;
    private TableHelper tBigIntegerEntity;

    @Before
    public void setUp() throws Exception {
        this.tBigIntegerEntity = new TableHelper(this.dbHelper, "BIGINTEGER_ENTITY");
        this.tBigIntegerEntity.setColumns(new String[]{"ID", "BIG_INTEGER_FIELD"});
    }

    @Test
    public void testABS() {
        BigDecimalEntity o1 = this.context.newObject(BigDecimalEntity.class);
        o1.setBigDecimalNumeric(new BigDecimal("4.1"));
        BigDecimalEntity o2 = this.context.newObject(BigDecimalEntity.class);
        o2.setBigDecimalNumeric(new BigDecimal("-5.1"));
        this.context.commitChanges();
        EJBQLQuery query = new EJBQLQuery("SELECT d FROM BigDecimalEntity d WHERE ABS(d.bigDecimalNumeric) < 5.0");
        List objects = this.context.performQuery(query);
        Assert.assertEquals((long)1L, (long)objects.size());
        Assert.assertTrue((boolean)objects.contains(o1));
    }

    @Test
    public void testSQRT() {
        BigDecimalEntity o1 = this.context.newObject(BigDecimalEntity.class);
        o1.setBigDecimalNumeric(new BigDecimal("9"));
        BigDecimalEntity o2 = this.context.newObject(BigDecimalEntity.class);
        o2.setBigDecimalNumeric(new BigDecimal("16"));
        this.context.commitChanges();
        EJBQLQuery query = new EJBQLQuery("SELECT d FROM BigDecimalEntity d WHERE SQRT(d.bigDecimalNumeric) > 3.1");
        List objects = this.context.performQuery(query);
        Assert.assertEquals((long)1L, (long)objects.size());
        Assert.assertTrue((boolean)objects.contains(o2));
    }

    @Test
    public void testMOD() {
        BigIntegerEntity o1 = this.context.newObject(BigIntegerEntity.class);
        o1.setBigIntegerField(new BigInteger("9"));
        BigIntegerEntity o2 = this.context.newObject(BigIntegerEntity.class);
        o2.setBigIntegerField(new BigInteger("10"));
        this.context.commitChanges();
        EJBQLQuery query = new EJBQLQuery("SELECT d FROM BigIntegerEntity d WHERE MOD(d.bigIntegerField, 4) = 2");
        List objects = this.context.performQuery(query);
        Assert.assertEquals((long)1L, (long)objects.size());
        Assert.assertTrue((boolean)objects.contains(o2));
    }

    @Test
    public void testUpdateNoQualifierBoolean() throws Exception {
        BooleanTestEntity o1 = this.context.newObject(BooleanTestEntity.class);
        o1.setBooleanColumn(Boolean.TRUE);
        BooleanTestEntity o2 = this.context.newObject(BooleanTestEntity.class);
        o2.setBooleanColumn(Boolean.FALSE);
        BooleanTestEntity o3 = this.context.newObject(BooleanTestEntity.class);
        o3.setBooleanColumn(Boolean.FALSE);
        this.context.commitChanges();
        EJBQLQuery check = new EJBQLQuery("select count(p) from BooleanTestEntity p WHERE p.booleanColumn = true");
        Object notUpdated = Cayenne.objectForQuery(this.context, check);
        Assert.assertEquals((Object)new Long(1L), (Object)notUpdated);
        String ejbql = "UPDATE BooleanTestEntity AS p SET p.booleanColumn = true";
        EJBQLQuery query = new EJBQLQuery(ejbql);
        QueryResponse result = this.context.performGenericQuery(query);
        int[] count = result.firstUpdateCount();
        Assert.assertNotNull((Object)count);
        Assert.assertEquals((long)1L, (long)count.length);
        Assert.assertEquals((long)3L, (long)count[0]);
        notUpdated = Cayenne.objectForQuery(this.context, check);
        Assert.assertEquals((Object)new Long(3L), (Object)notUpdated);
    }
}

