/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.List;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.FunctionExpressionFactory;
import org.apache.cayenne.exp.Property;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.testdo.testmap.Painting;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class DataContextOrderingIT
extends ServerCase {
    @Inject
    private DataContext context;

    @Test
    public void testMultipleOrdering() {
        Calendar c = Calendar.getInstance();
        Artist a1 = this.context.newObject(Artist.class);
        a1.setArtistName("2");
        a1.setDateOfBirth(c.getTime());
        c.add(5, -1);
        Artist a2 = this.context.newObject(Artist.class);
        a2.setArtistName("3");
        a2.setDateOfBirth(c.getTime());
        c.add(5, -1);
        Artist a3 = this.context.newObject(Artist.class);
        a3.setArtistName("3");
        a3.setDateOfBirth(c.getTime());
        this.context.commitChanges();
        SelectQuery<Artist> query = new SelectQuery<Artist>(Artist.class);
        query.addOrdering(Artist.ARTIST_NAME.desc());
        query.addOrdering(Artist.DATE_OF_BIRTH.desc());
        List<Artist> list = query.select(this.context);
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertSame((Object)a2, (Object)list.get(0));
        Assert.assertSame((Object)a3, (Object)list.get(1));
        Assert.assertSame((Object)a1, (Object)list.get(2));
    }

    @Test
    public void testMultipleOrderingInSelectClauseCAY_1074() throws Exception {
        Calendar c = Calendar.getInstance();
        Artist a1 = this.context.newObject(Artist.class);
        a1.setArtistName("2");
        a1.setDateOfBirth(c.getTime());
        c.add(5, -1);
        Artist a2 = this.context.newObject(Artist.class);
        a2.setArtistName("3");
        a2.setDateOfBirth(c.getTime());
        c.add(5, -1);
        Artist a3 = this.context.newObject(Artist.class);
        a3.setArtistName("3");
        a3.setDateOfBirth(c.getTime());
        Painting p1 = this.context.newObject(Painting.class);
        p1.setEstimatedPrice(new BigDecimal(1));
        p1.setPaintingTitle("Y");
        a1.addToPaintingArray(p1);
        Painting p2 = this.context.newObject(Painting.class);
        p2.setEstimatedPrice(new BigDecimal(2));
        p2.setPaintingTitle("X");
        a2.addToPaintingArray(p2);
        this.context.commitChanges();
        SelectQuery<Artist> query1 = new SelectQuery<Artist>(Artist.class);
        query1.andQualifier(Artist.PAINTING_ARRAY.ne((List)null));
        query1.addOrdering(Artist.ARTIST_NAME.desc());
        query1.addOrdering(Artist.DATE_OF_BIRTH.desc());
        List<Artist> list1 = query1.select(this.context);
        Assert.assertEquals((long)2L, (long)list1.size());
    }

    @Test
    public void testCustomPropertySort() throws Exception {
        Calendar c = Calendar.getInstance();
        Artist a1 = this.context.newObject(Artist.class);
        a1.setArtistName("31");
        a1.setDateOfBirth(c.getTime());
        c.add(5, -1);
        Artist a2 = this.context.newObject(Artist.class);
        a2.setArtistName("22");
        a2.setDateOfBirth(c.getTime());
        c.add(5, -1);
        Artist a3 = this.context.newObject(Artist.class);
        a3.setArtistName("13");
        a3.setDateOfBirth(c.getTime());
        this.context.commitChanges();
        Expression exp = FunctionExpressionFactory.substringExp(Artist.ARTIST_NAME.path(), 2, 1);
        Property<String> nameSubstr = Property.create("name", exp, String.class);
        SelectQuery<Artist> query = new SelectQuery<Artist>(Artist.class);
        query.addOrdering(nameSubstr.desc());
        List<Artist> list = query.select(this.context);
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertSame((Object)a3, (Object)list.get(0));
        Assert.assertSame((Object)a2, (Object)list.get(1));
        Assert.assertSame((Object)a1, (Object)list.get(2));
    }
}

