/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.ArrayList;
import java.util.List;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.access.MockDataContextDelegate;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.MockQuery;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.testdo.testmap.Gallery;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class DataContextDelegateIT
extends ServerCase {
    @Inject
    private DataContext context;

    @Before
    public void setUp() throws Exception {
        Gallery gallery = (Gallery)this.context.newObject("Gallery");
        gallery.setGalleryName("version1");
        Artist artist = (Artist)this.context.newObject("Artist");
        artist.setArtistName("version1");
        this.context.commitChanges();
    }

    @Test
    public void testWillPerformGenericQuery() throws Exception {
        final ArrayList queriesPerformed = new ArrayList(1);
        MockDataContextDelegate delegate = new MockDataContextDelegate(){

            @Override
            public Query willPerformGenericQuery(DataContext context, Query query) {
                queriesPerformed.add(query);
                return query;
            }
        };
        this.context.setDelegate(delegate);
        MockQuery query = new MockQuery();
        this.context.performGenericQuery(query);
        Assert.assertTrue((String)"Delegate is not notified of a query being run.", (boolean)queriesPerformed.contains(query));
        Assert.assertEquals((long)1L, (long)queriesPerformed.size());
        Assert.assertTrue((String)"Delegate unexpectedly blocked the query.", (boolean)query.isRouteCalled());
    }

    @Test
    public void testWillPerformGenericQueryBlocked() throws Exception {
        final ArrayList queriesPerformed = new ArrayList(1);
        MockDataContextDelegate delegate = new MockDataContextDelegate(){

            @Override
            public Query willPerformGenericQuery(DataContext context, Query query) {
                queriesPerformed.add(query);
                return null;
            }
        };
        this.context.setDelegate(delegate);
        MockQuery query = new MockQuery();
        this.context.performGenericQuery(query);
        Assert.assertTrue((String)"Delegate is not notified of a query being run.", (boolean)queriesPerformed.contains(query));
        Assert.assertEquals((long)1L, (long)queriesPerformed.size());
        Assert.assertFalse((String)"Delegate couldn't block the query.", (boolean)query.isRouteCalled());
    }

    @Test
    public void testWillPerformQuery() throws Exception {
        final ArrayList queriesPerformed = new ArrayList(1);
        MockDataContextDelegate delegate = new MockDataContextDelegate(){

            @Override
            public Query willPerformQuery(DataContext context, Query query) {
                queriesPerformed.add(query);
                return query;
            }
        };
        this.context.setDelegate(delegate);
        SelectQuery<Gallery> query = new SelectQuery<Gallery>(Gallery.class);
        List results = this.context.performQuery(query);
        Assert.assertTrue((String)"Delegate is not notified of a query being run.", (boolean)queriesPerformed.contains(query));
        Assert.assertEquals((long)1L, (long)queriesPerformed.size());
        Assert.assertNotNull((Object)results);
    }

    @Test
    public void testWillPerformQueryBlocked() throws Exception {
        final ArrayList queriesPerformed = new ArrayList(1);
        MockDataContextDelegate delegate = new MockDataContextDelegate(){

            @Override
            public Query willPerformQuery(DataContext context, Query query) {
                queriesPerformed.add(query);
                return null;
            }
        };
        this.context.setDelegate(delegate);
        SelectQuery<Gallery> query = new SelectQuery<Gallery>(Gallery.class);
        List results = this.context.performQuery(query);
        Assert.assertTrue((String)"Delegate is not notified of a query being run.", (boolean)queriesPerformed.contains(query));
        Assert.assertEquals((long)1L, (long)queriesPerformed.size());
        Assert.assertNotNull((Object)results);
        Assert.assertEquals((String)"Delegate couldn't block the query.", (long)0L, (long)results.size());
    }
}

