/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne;

import java.util.Set;
import org.apache.cayenne.Cayenne;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.ValueHolder;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.RefreshQuery;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.relationships_set_to_many.SetToMany;
import org.apache.cayenne.testdo.relationships_set_to_many.SetToManyTarget;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-relationships-set-to-many.xml")
public class CDOSetRelationshipIT
extends ServerCase {
    @Inject
    protected ObjectContext context;
    @Inject
    protected DBHelper dbHelper;
    protected TableHelper tSetToMany;
    protected TableHelper tSetToManyTarget;

    @Before
    public void setUp() throws Exception {
        this.tSetToMany = new TableHelper(this.dbHelper, "SET_TO_MANY");
        this.tSetToMany.setColumns(new String[]{"ID"});
        this.tSetToManyTarget = new TableHelper(this.dbHelper, "SET_TO_MANY_TARGET");
        this.tSetToManyTarget.setColumns(new String[]{"ID", "SET_TO_MANY_ID"});
    }

    protected void createTestDataSet() throws Exception {
        this.tSetToMany.insert(new Object[]{1});
        this.tSetToMany.insert(new Object[]{2});
        this.tSetToManyTarget.insert(new Object[]{1, 1});
        this.tSetToManyTarget.insert(new Object[]{2, 1});
        this.tSetToManyTarget.insert(new Object[]{3, 1});
        this.tSetToManyTarget.insert(new Object[]{4, 2});
    }

    @Test
    public void testReadToMany() throws Exception {
        this.createTestDataSet();
        SetToMany o1 = Cayenne.objectForPK(this.context, SetToMany.class, 1);
        Set<SetToManyTarget> targets = o1.getTargets();
        Assert.assertNotNull(targets);
        Assert.assertTrue((boolean)((ValueHolder)((Object)targets)).isFault());
        Assert.assertEquals((long)3L, (long)targets.size());
        Assert.assertTrue((boolean)targets.contains(Cayenne.objectForPK(o1.getObjectContext(), SetToManyTarget.class, 1)));
        Assert.assertTrue((boolean)targets.contains(Cayenne.objectForPK(o1.getObjectContext(), SetToManyTarget.class, 2)));
        Assert.assertTrue((boolean)targets.contains(Cayenne.objectForPK(o1.getObjectContext(), SetToManyTarget.class, 3)));
    }

    @Test
    public void testReadToManyPrefetching() throws Exception {
        this.createTestDataSet();
        SelectQuery<SetToMany> query = new SelectQuery<SetToMany>(SetToMany.class, ExpressionFactory.matchDbExp("ID", new Integer(1)));
        query.addPrefetch(SetToMany.TARGETS.disjoint());
        SetToMany o1 = (SetToMany)Cayenne.objectForQuery(this.context, query);
        Set<SetToManyTarget> targets = o1.getTargets();
        Assert.assertFalse((boolean)((ValueHolder)((Object)targets)).isFault());
        Assert.assertNotNull(targets);
        Assert.assertEquals((long)3L, (long)targets.size());
        Assert.assertTrue((boolean)targets.contains(Cayenne.objectForPK(o1.getObjectContext(), SetToManyTarget.class, 1)));
        Assert.assertTrue((boolean)targets.contains(Cayenne.objectForPK(o1.getObjectContext(), SetToManyTarget.class, 2)));
        Assert.assertTrue((boolean)targets.contains(Cayenne.objectForPK(o1.getObjectContext(), SetToManyTarget.class, 3)));
    }

    @Test
    public void testAddToMany() throws Exception {
        this.createTestDataSet();
        SetToMany o1 = Cayenne.objectForPK(this.context, SetToMany.class, 1);
        Set<SetToManyTarget> targets = o1.getTargets();
        Assert.assertNotNull(targets);
        Assert.assertEquals((long)3L, (long)targets.size());
        SetToManyTarget newTarget = o1.getObjectContext().newObject(SetToManyTarget.class);
        o1.addToTargets(newTarget);
        Assert.assertEquals((long)4L, (long)targets.size());
        Assert.assertTrue((boolean)o1.getTargets().contains(newTarget));
        Assert.assertSame((Object)o1, (Object)newTarget.getSetToMany());
        o1.getObjectContext().commitChanges();
        o1.getObjectContext().performGenericQuery(new RefreshQuery());
        Assert.assertEquals((long)4L, (long)o1.getTargets().size());
    }

    @Test
    public void testRemoveToMany() throws Exception {
        this.createTestDataSet();
        SetToMany o1 = Cayenne.objectForPK(this.context, SetToMany.class, 1);
        Set<SetToManyTarget> targets = o1.getTargets();
        Assert.assertEquals((long)3L, (long)targets.size());
        SetToManyTarget target = Cayenne.objectForPK(o1.getObjectContext(), SetToManyTarget.class, 2);
        o1.removeFromTargets(target);
        Assert.assertEquals((long)2L, (long)targets.size());
        Assert.assertFalse((boolean)o1.getTargets().contains(target));
        Assert.assertNull((Object)target.getSetToMany());
        o1.getObjectContext().commitChanges();
        o1.getObjectContext().performGenericQuery(new RefreshQuery());
        Assert.assertEquals((long)2L, (long)o1.getTargets().size());
        Assert.assertFalse((boolean)o1.getTargets().contains(target));
    }

    @Test
    public void testAddToManyViaReverse() throws Exception {
        this.createTestDataSet();
        SetToMany o1 = Cayenne.objectForPK(this.context, SetToMany.class, 1);
        Set<SetToManyTarget> targets = o1.getTargets();
        Assert.assertNotNull(targets);
        Assert.assertEquals((long)3L, (long)targets.size());
        SetToManyTarget newTarget = o1.getObjectContext().newObject(SetToManyTarget.class);
        newTarget.setSetToMany(o1);
        Assert.assertEquals((long)4L, (long)targets.size());
        Assert.assertTrue((boolean)o1.getTargets().contains(newTarget));
        Assert.assertSame((Object)o1, (Object)newTarget.getSetToMany());
        o1.getObjectContext().commitChanges();
        o1.getObjectContext().performGenericQuery(new RefreshQuery());
        Assert.assertEquals((long)4L, (long)o1.getTargets().size());
    }
}

