/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.util;

import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.testdo.mt.ClientMtTable1;
import org.apache.cayenne.testdo.mt.ClientMtTable2;
import org.apache.cayenne.util.PersistentObjectHolder;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class PersistentObjectHolderTest {
    @Test
    public void testSetInitialValue() {
        ObjectContext context = (ObjectContext)Mockito.mock(ObjectContext.class);
        ClientMtTable2 o = new ClientMtTable2();
        o.setPersistenceState(3);
        o.setObjectContext(context);
        PersistentObjectHolder<ClientMtTable1> holder = new PersistentObjectHolder<ClientMtTable1>(o, "table1");
        Assert.assertTrue((boolean)holder.isFault());
        ClientMtTable1 o1 = new ClientMtTable1();
        o1.setObjectContext(context);
        holder.setValueDirectly(o1);
        Assert.assertFalse((boolean)holder.isFault());
        Assert.assertSame((Object)o1, holder.value);
    }

    @Test
    public void testInvalidate() {
        ObjectContext context = (ObjectContext)Mockito.mock(ObjectContext.class);
        ClientMtTable2 o = new ClientMtTable2();
        o.setPersistenceState(3);
        o.setObjectContext(context);
        PersistentObjectHolder<ClientMtTable1> holder = new PersistentObjectHolder<ClientMtTable1>(o, "table1");
        Assert.assertTrue((boolean)holder.isFault());
        ClientMtTable1 o1 = new ClientMtTable1();
        o1.setObjectContext(context);
        holder.setValueDirectly(o1);
        holder.invalidate();
        Assert.assertTrue((boolean)holder.isFault());
        Assert.assertNull(holder.value);
    }
}

