/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.unit;

import java.sql.Connection;
import java.util.Arrays;
import java.util.Collection;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.unit.UnitDbAdapter;

public class MySQLUnitDbAdapter
extends UnitDbAdapter {
    static final Collection<String> NO_CONSTRAINTS_TABLES = Arrays.asList("REFLEXIVE_AND_TO_ONE", "ARTGROUP", "FK_OF_DIFFERENT_TYPE");

    public MySQLUnitDbAdapter(DbAdapter adapter) {
        super(adapter);
    }

    @Override
    public String getIdentifiersStartQuote() {
        return "`";
    }

    @Override
    public String getIdentifiersEndQuote() {
        return "`";
    }

    @Override
    public boolean supportsCatalogs() {
        return true;
    }

    @Override
    public boolean realAsDouble() {
        return true;
    }

    @Override
    public boolean supportsLobs() {
        return true;
    }

    @Override
    public boolean supportsBitwiseOps() {
        return true;
    }

    @Override
    public boolean supportsCaseSensitiveLike() {
        return false;
    }

    @Override
    public boolean supportsStoredProcedures() {
        return true;
    }

    @Override
    public boolean supportsTrimChar() {
        return true;
    }

    @Override
    public void createdTables(Connection con, DataMap map) throws Exception {
        if (map.getProcedureMap().containsKey("cayenne_tst_select_proc")) {
            this.executeDDL(con, "mysql", "create-select-sp.sql");
            this.executeDDL(con, "mysql", "create-update-sp.sql");
            this.executeDDL(con, "mysql", "create-update-sp2.sql");
            this.executeDDL(con, "mysql", "create-out-sp.sql");
        }
    }

    @Override
    public void willDropTables(Connection conn, DataMap map, Collection<String> tablesToDrop) throws Exception {
        Procedure proc = map.getProcedure("cayenne_tst_select_proc");
        if (proc != null && proc.getDataMap() == map) {
            this.executeDDL(conn, "mysql", "drop-select-sp.sql");
            this.executeDDL(conn, "mysql", "drop-update-sp.sql");
            this.executeDDL(conn, "mysql", "drop-update-sp2.sql");
            this.executeDDL(conn, "mysql", "drop-out-sp.sql");
        }
    }

    @Override
    public boolean supportsFKConstraints(DbEntity entity) {
        return !NO_CONSTRAINTS_TABLES.contains(entity.getName());
    }

    @Override
    public boolean supportsGeneratedKeysAdd() {
        return true;
    }

    @Override
    public boolean supportsGeneratedKeysDrop() {
        return true;
    }
}

