/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.map;

import java.util.Collections;
import org.apache.cayenne.CayenneDataObject;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-generic.xml")
public class EntityResolverGenericStackIT
extends ServerCase {
    @Inject
    private EntityResolver resolver;

    @Test
    public void testObjEntityLookupDuplicates() {
        DataMap generic = this.resolver.getDataMap("generic");
        EntityResolver resolver = new EntityResolver(Collections.singleton(generic));
        ObjEntity g1 = resolver.getObjEntity("Generic1");
        Assert.assertNotNull((Object)g1);
        ObjEntity g2 = resolver.getObjEntity("Generic2");
        Assert.assertNotNull((Object)g2);
        Assert.assertNotSame((Object)g1, (Object)g2);
        Assert.assertNull((Object)resolver.getObjEntity(Object.class));
        try {
            resolver.getObjEntity(CayenneDataObject.class);
            Assert.fail((String)"two entities mapped to the same class... resolver must have thrown.");
        }
        catch (CayenneRuntimeException cayenneRuntimeException) {
            // empty catch block
        }
    }
}

