/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.map;

import java.util.Collection;
import org.apache.cayenne.configuration.server.ServerRuntime;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.apache.cayenne.util.Util;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class DbEntityIT
extends ServerCase {
    @Inject
    private ServerRuntime runtime;

    @Test
    public void testSerializability() throws Exception {
        DbEntity entity = new DbEntity("entity");
        DbAttribute pk = new DbAttribute("pk");
        pk.setPrimaryKey(true);
        entity.addAttribute(pk);
        DbAttribute generated = new DbAttribute("generated");
        generated.setGenerated(true);
        entity.addAttribute(generated);
        DbEntity d2 = Util.cloneViaSerialization(entity);
        Assert.assertNotNull(d2.getPrimaryKeys());
        Assert.assertEquals((long)entity.getPrimaryKeys().size(), (long)d2.getPrimaryKeys().size());
        DbAttribute pk2 = d2.getAttribute(pk.getName());
        Assert.assertNotNull((Object)pk2);
        Assert.assertTrue((boolean)d2.getPrimaryKeys().contains(pk2));
        Assert.assertNotNull(d2.getGeneratedAttributes());
        Assert.assertEquals((long)entity.getGeneratedAttributes().size(), (long)d2.getGeneratedAttributes().size());
        DbAttribute generated2 = d2.getAttribute(generated.getName());
        Assert.assertNotNull((Object)generated2);
        Assert.assertTrue((boolean)d2.getGeneratedAttributes().contains(generated2));
    }

    @Test
    public void testConstructor1() {
        DbEntity ent = new DbEntity();
        Assert.assertNull((Object)ent.getName());
    }

    @Test
    public void testConstructor2() {
        DbEntity ent = new DbEntity("abc");
        Assert.assertEquals((Object)"abc", (Object)ent.getName());
    }

    @Test
    public void testCatalog() {
        String tstName = "tst_name";
        DbEntity ent = new DbEntity("abc");
        ent.setCatalog(tstName);
        Assert.assertEquals((Object)tstName, (Object)ent.getCatalog());
    }

    @Test
    public void testSchema() {
        String tstName = "tst_name";
        DbEntity ent = new DbEntity("abc");
        ent.setSchema(tstName);
        Assert.assertEquals((Object)tstName, (Object)ent.getSchema());
    }

    @Test
    public void testFullyQualifiedName() {
        DbEntity e1 = new DbEntity("e1");
        Assert.assertEquals((Object)"e1", (Object)e1.getFullyQualifiedName());
        DbEntity e2 = new DbEntity("e2");
        e2.setSchema("s2");
        Assert.assertEquals((Object)"e2", (Object)e2.getName());
        Assert.assertEquals((Object)"s2.e2", (Object)e2.getFullyQualifiedName());
        DbEntity e3 = new DbEntity("e3");
        e3.setSchema("s3");
        e3.setCatalog("c3");
        Assert.assertEquals((Object)"e3", (Object)e3.getName());
        Assert.assertEquals((Object)"c3.s3.e3", (Object)e3.getFullyQualifiedName());
        DbEntity e4 = new DbEntity("e4");
        e4.setCatalog("c4");
        Assert.assertEquals((Object)"e4", (Object)e4.getName());
        Assert.assertEquals((Object)"c4.e4", (Object)e4.getFullyQualifiedName());
    }

    @Test
    public void testGetPrimaryKey() {
        DbEntity ent = new DbEntity("abc");
        DbAttribute a1 = new DbAttribute();
        a1.setName("a1");
        a1.setPrimaryKey(false);
        ent.addAttribute(a1);
        DbAttribute a2 = new DbAttribute();
        a2.setName("a2");
        a2.setPrimaryKey(true);
        ent.addAttribute(a2);
        Collection<DbAttribute> pk = ent.getPrimaryKeys();
        Assert.assertNotNull(pk);
        Assert.assertEquals((long)1L, (long)pk.size());
        Assert.assertSame((Object)a2, (Object)pk.iterator().next());
    }

    @Test
    public void testAddPKAttribute() {
        DbEntity ent = new DbEntity("abc");
        DbAttribute a1 = new DbAttribute();
        a1.setName("a1");
        a1.setPrimaryKey(false);
        Assert.assertTrue((boolean)ent.getPrimaryKeys().isEmpty());
        ent.addAttribute(a1);
        Assert.assertTrue((boolean)ent.getPrimaryKeys().isEmpty());
    }

    @Test
    public void testChangeAttributeToPK() {
        DbEntity ent = new DbEntity("abc");
        DbAttribute a1 = new DbAttribute();
        a1.setName("a1");
        a1.setPrimaryKey(false);
        ent.addAttribute(a1);
        Assert.assertFalse((boolean)ent.getPrimaryKeys().contains(a1));
        a1.setPrimaryKey(true);
        Assert.assertTrue((boolean)ent.getPrimaryKeys().contains(a1));
    }

    @Test
    public void testChangePKAttribute() {
        DbEntity ent = new DbEntity("abc");
        DbAttribute a1 = new DbAttribute();
        a1.setName("a1");
        a1.setPrimaryKey(true);
        ent.addAttribute(a1);
        Assert.assertTrue((boolean)ent.getPrimaryKeys().contains(a1));
        a1.setPrimaryKey(false);
        Assert.assertFalse((boolean)ent.getPrimaryKeys().contains(a1));
    }

    @Test
    public void testRemoveAttribute() {
        DbEntity ent = new DbEntity("abc");
        DataMap map = new DataMap("map");
        ent.setName("ent");
        map.addDbEntity(ent);
        DbAttribute a1 = new DbAttribute();
        a1.setName("a1");
        a1.setPrimaryKey(false);
        ent.addAttribute(a1);
        DbEntity otherEntity = new DbEntity("22ent1");
        Assert.assertNotNull((Object)otherEntity.getName());
        map.addDbEntity(otherEntity);
        DbAttribute a11 = new DbAttribute();
        a11.setName("a11");
        a11.setPrimaryKey(false);
        otherEntity.addAttribute(a11);
        DbRelationship rel = new DbRelationship("relfrom");
        ent.addRelationship(rel);
        rel.setTargetEntityName(otherEntity);
        rel.addJoin(new DbJoin(rel, "a1", "a11"));
        DbRelationship rel1 = new DbRelationship("relto");
        otherEntity.addRelationship(rel1);
        rel1.setTargetEntityName(ent);
        rel1.addJoin(new DbJoin(rel1, "a11", "a1"));
        Assert.assertSame((Object)a1, (Object)ent.getAttribute(a1.getName()));
        Assert.assertSame((Object)rel, (Object)ent.getRelationship(rel.getName()));
        ent.removeAttribute(a1.getName());
        Assert.assertNull((Object)ent.getAttribute(a1.getName()));
        Assert.assertEquals((long)0L, (long)rel1.getJoins().size());
        Assert.assertEquals((long)0L, (long)rel.getJoins().size());
    }

    @Test
    public void testTranslateToRelatedEntityIndependentPath() {
        DbEntity artistE = this.runtime.getDataDomain().getEntityResolver().getDbEntity("ARTIST");
        Expression e1 = ExpressionFactory.exp("db:paintingArray", new Object[0]);
        Expression translated = artistE.translateToRelatedEntity(e1, "artistExhibitArray");
        Assert.assertEquals((String)("failure: " + translated), (Object)ExpressionFactory.exp("db:toArtist.paintingArray", new Object[0]), (Object)translated);
    }

    @Test
    public void testTranslateToRelatedEntityTrimmedPath() {
        DbEntity artistE = this.runtime.getDataDomain().getEntityResolver().getDbEntity("ARTIST");
        Expression e1 = ExpressionFactory.exp("db:artistExhibitArray.toExhibit", new Object[0]);
        Expression translated = artistE.translateToRelatedEntity(e1, "artistExhibitArray");
        Assert.assertEquals((String)("failure: " + translated), (Object)ExpressionFactory.exp("db:toArtist.artistExhibitArray.toExhibit", new Object[0]), (Object)translated);
    }

    @Test
    public void testTranslateToRelatedEntitySplitHalfWay() {
        DbEntity artistE = this.runtime.getDataDomain().getEntityResolver().getDbEntity("ARTIST");
        Expression e1 = ExpressionFactory.exp("db:paintingArray.toPaintingInfo.TEXT_REVIEW", new Object[0]);
        Expression translated = artistE.translateToRelatedEntity(e1, "paintingArray.toGallery");
        Assert.assertEquals((String)("failure: " + translated), (Object)ExpressionFactory.exp("db:paintingArray.toArtist.paintingArray.toPaintingInfo.TEXT_REVIEW", new Object[0]), (Object)translated);
    }

    @Test
    public void testTranslateToRelatedEntityMatchingPath() {
        DbEntity artistE = this.runtime.getDataDomain().getEntityResolver().getDbEntity("ARTIST");
        Expression e1 = ExpressionFactory.exp("db:artistExhibitArray.toExhibit", new Object[0]);
        Expression translated = artistE.translateToRelatedEntity(e1, "artistExhibitArray.toExhibit");
        Assert.assertEquals((String)("failure: " + translated), (Object)ExpressionFactory.exp("db:artistExhibitArray.toArtist.artistExhibitArray.toExhibit", new Object[0]), (Object)translated);
    }

    @Test
    public void testTranslateToRelatedEntityToOne() {
        DbEntity paintingE = this.runtime.getDataDomain().getEntityResolver().getDbEntity("PAINTING");
        Expression e1 = ExpressionFactory.exp("db:toArtist.ARTIST_NAME = 'aa'", new Object[0]);
        Expression translated = paintingE.translateToRelatedEntity(e1, "toArtist");
        Assert.assertEquals((String)("failure: " + translated), (Object)ExpressionFactory.exp("db:paintingArray.toArtist.ARTIST_NAME = 'aa'", new Object[0]), (Object)translated);
    }
}

