/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.configuration.xml;

import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.configuration.xml.LoaderContext;
import org.apache.cayenne.configuration.xml.VersionAwareHandler;
import org.junit.Before;
import org.junit.Test;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class VersionAwareHandlerTest {
    private static String[] VERSION_SET_1 = new String[]{"10", "11", "9"};
    private static String[] VERSION_SET_2 = new String[]{"10"};
    VersionAwareHandler handler;

    @Before
    public void createHandler() {
        this.handler = new VersionAwareHandler(new LoaderContext(null, null), "test"){};
    }

    private Attributes createAttributesWithVersion(String version) {
        AttributesImpl attributes = new AttributesImpl();
        attributes.addAttribute("", "project-version", "project-version", "", version);
        return attributes;
    }

    @Test
    public void validateCorrectVersion() {
        this.handler.validateVersion(this.createAttributesWithVersion("9"), VERSION_SET_1);
        this.handler.validateVersion(this.createAttributesWithVersion("10"), VERSION_SET_1);
        this.handler.validateVersion(this.createAttributesWithVersion("11"), VERSION_SET_1);
        this.handler.validateVersion(this.createAttributesWithVersion("10"), VERSION_SET_2);
    }

    @Test(expected=CayenneRuntimeException.class)
    public void validateIncorrectVersion1() {
        this.handler.validateVersion(this.createAttributesWithVersion("8"), VERSION_SET_1);
    }

    @Test(expected=CayenneRuntimeException.class)
    public void validateIncorrectVersion2() {
        this.handler.validateVersion(this.createAttributesWithVersion("11"), VERSION_SET_2);
    }
}

