/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.configuration.xml;

import org.apache.cayenne.configuration.xml.BaseHandlerTest;
import org.apache.cayenne.configuration.xml.DbRelationshipHandler;
import org.apache.cayenne.configuration.xml.NamespaceAwareNestedTagHandler;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.junit.Assert;
import org.junit.Test;

public class DbRelationshipHandlerTest
extends BaseHandlerTest {
    @Test
    public void testParsing() throws Exception {
        final DataMap map = new DataMap();
        DbEntity entity = new DbEntity("ARTIST");
        map.addDbEntity(entity);
        Assert.assertEquals((long)0L, (long)entity.getRelationships().size());
        this.parse("db-relationship", new BaseHandlerTest.HandlerFactory(){

            @Override
            public NamespaceAwareNestedTagHandler createHandler(NamespaceAwareNestedTagHandler parent) {
                return new DbRelationshipHandler(parent, map);
            }
        });
        Assert.assertEquals((long)1L, (long)entity.getRelationships().size());
        DbRelationship relationship = entity.getRelationship("artistPaintings");
        Assert.assertNotNull((Object)relationship);
        Assert.assertEquals((Object)"PAINTING", (Object)relationship.getTargetEntityName());
        Assert.assertTrue((boolean)relationship.isToDependentPK());
        Assert.assertTrue((boolean)relationship.isToMany());
        Assert.assertEquals((Object)"ID", (Object)relationship.getJoins().get(0).getSourceName());
        Assert.assertEquals((Object)"ARTIST_ID", (Object)relationship.getJoins().get(0).getTargetName());
    }
}

