/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.List;
import org.apache.cayenne.Cayenne;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.EJBQLQuery;
import org.apache.cayenne.query.QueryChain;
import org.apache.cayenne.query.SQLTemplate;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.testdo.testmap.Painting;
import org.apache.cayenne.unit.UnitDbAdapter;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class DataContextEJBQLFunctionalExpressionsIT
extends ServerCase {
    @Inject
    private ObjectContext context;
    @Inject
    private UnitDbAdapter accessStackAdapter;

    @Test
    public void testSIZE() {
        Artist a1 = this.context.newObject(Artist.class);
        a1.setArtistName("a1");
        Artist a2 = this.context.newObject(Artist.class);
        a2.setArtistName("a2");
        Painting p12 = this.context.newObject(Painting.class);
        p12.setPaintingTitle("p12");
        a2.addToPaintingArray(p12);
        Painting p22 = this.context.newObject(Painting.class);
        p22.setPaintingTitle("p22");
        a2.addToPaintingArray(p22);
        this.context.commitChanges();
    }

    @Test
    public void testCONCAT() {
        Painting a1 = this.context.newObject(Painting.class);
        a1.setPaintingTitle("a1");
        Painting a2 = this.context.newObject(Painting.class);
        a2.setPaintingTitle("a2");
        this.context.commitChanges();
        EJBQLQuery query = new EJBQLQuery("SELECT a FROM Painting a WHERE CONCAT(a.paintingTitle, a.paintingTitle) = 'a1a1'");
        List objects = this.context.performQuery(query);
        Assert.assertEquals((long)1L, (long)objects.size());
        Assert.assertTrue((boolean)objects.contains(a1));
    }

    @Test
    public void testSUBSTRING() {
        Artist a1 = this.context.newObject(Artist.class);
        a1.setArtistName("12345678");
        Artist a2 = this.context.newObject(Artist.class);
        a2.setArtistName("abcdefg");
        this.context.commitChanges();
        EJBQLQuery query = new EJBQLQuery("SELECT a FROM Artist a WHERE SUBSTRING(a.artistName, 2, 3) = 'bcd'");
        List objects = this.context.performQuery(query);
        Assert.assertEquals((long)1L, (long)objects.size());
        Assert.assertTrue((boolean)objects.contains(a2));
    }

    @Test
    public void testLOWER() {
        Artist a1 = this.context.newObject(Artist.class);
        a1.setArtistName("ABCDEFG");
        Artist a2 = this.context.newObject(Artist.class);
        a2.setArtistName("abcdefg");
        this.context.commitChanges();
        Artist a3 = this.context.newObject(Artist.class);
        a3.setArtistName("Xabcdefg");
        this.context.commitChanges();
        EJBQLQuery query = new EJBQLQuery("SELECT a FROM Artist a WHERE LOWER(a.artistName) = 'abcdefg'");
        List objects = this.context.performQuery(query);
        Assert.assertEquals((long)2L, (long)objects.size());
        Assert.assertTrue((boolean)objects.contains(a1));
        Assert.assertTrue((boolean)objects.contains(a2));
    }

    @Test
    public void testUPPER() {
        Artist a1 = this.context.newObject(Artist.class);
        a1.setArtistName("ABCDEFG");
        Artist a2 = this.context.newObject(Artist.class);
        a2.setArtistName("abcdefg");
        this.context.commitChanges();
        Artist a3 = this.context.newObject(Artist.class);
        a3.setArtistName("Xabcdefg");
        this.context.commitChanges();
        EJBQLQuery query = new EJBQLQuery("SELECT a FROM Artist a WHERE UPPER(a.artistName) = UPPER('abcdefg')");
        List objects = this.context.performQuery(query);
        Assert.assertEquals((long)2L, (long)objects.size());
        Assert.assertTrue((boolean)objects.contains(a1));
        Assert.assertTrue((boolean)objects.contains(a2));
    }

    @Test
    public void testLENGTH() {
        Artist a1 = this.context.newObject(Artist.class);
        a1.setArtistName("1234567");
        Artist a2 = this.context.newObject(Artist.class);
        a2.setArtistName("1234567890");
        Artist a3 = this.context.newObject(Artist.class);
        a3.setArtistName("1234567890-=");
        this.context.commitChanges();
        EJBQLQuery query = new EJBQLQuery("SELECT a FROM Artist a WHERE LENGTH(a.artistName) > 7");
        List objects = this.context.performQuery(query);
        Assert.assertEquals((long)2L, (long)objects.size());
        Assert.assertTrue((boolean)objects.contains(a3));
        Assert.assertTrue((boolean)objects.contains(a2));
    }

    @Test
    public void testLOCATE() {
        Artist a1 = this.context.newObject(Artist.class);
        a1.setArtistName("___A___");
        Artist a2 = this.context.newObject(Artist.class);
        a2.setArtistName("_A_____");
        this.context.commitChanges();
        EJBQLQuery query = new EJBQLQuery("SELECT a FROM Artist a WHERE LOCATE('A', a.artistName) = 2");
        List objects = this.context.performQuery(query);
        Assert.assertEquals((long)1L, (long)objects.size());
        Assert.assertTrue((boolean)objects.contains(a2));
    }

    @Test
    public void testTRIM() {
        QueryChain inserts = new QueryChain();
        inserts.addQuery(new SQLTemplate(Artist.class, "INSERT INTO ARTIST (ARTIST_ID,ARTIST_NAME) VALUES(1, '  A')"));
        inserts.addQuery(new SQLTemplate(Artist.class, "INSERT INTO ARTIST (ARTIST_ID,ARTIST_NAME) VALUES(2, 'A  ')"));
        this.context.performGenericQuery(inserts);
        Artist a1 = Cayenne.objectForPK(this.context, Artist.class, 1);
        Artist a2 = Cayenne.objectForPK(this.context, Artist.class, 2);
        EJBQLQuery query = new EJBQLQuery("SELECT a FROM Artist a WHERE TRIM(a.artistName) = 'A'");
        List objects = this.context.performQuery(query);
        Assert.assertEquals((long)2L, (long)objects.size());
        Assert.assertTrue((boolean)objects.contains(a1));
        Assert.assertTrue((boolean)objects.contains(a2));
        query = new EJBQLQuery("SELECT a FROM Artist a WHERE TRIM(LEADING FROM a.artistName) = 'A'");
        objects = this.context.performQuery(query);
        Assert.assertTrue((objects.size() == 1 || objects.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)objects.contains(a1));
        query = new EJBQLQuery("SELECT a FROM Artist a WHERE TRIM(TRAILING FROM a.artistName) = 'A'");
        objects = this.context.performQuery(query);
        Assert.assertEquals((long)1L, (long)objects.size());
        Assert.assertTrue((boolean)objects.contains(a2));
        query = new EJBQLQuery("SELECT a FROM Artist a WHERE TRIM(BOTH FROM a.artistName) = 'A'");
        objects = this.context.performQuery(query);
        Assert.assertEquals((long)2L, (long)objects.size());
        Assert.assertTrue((boolean)objects.contains(a1));
        Assert.assertTrue((boolean)objects.contains(a2));
    }

    @Test
    public void testTRIMChar() {
        if (!this.accessStackAdapter.supportsTrimChar()) {
            return;
        }
        Artist a1 = this.context.newObject(Artist.class);
        a1.setArtistName("XXXA");
        Artist a2 = this.context.newObject(Artist.class);
        a2.setArtistName("AXXX");
        this.context.commitChanges();
        EJBQLQuery query = new EJBQLQuery("SELECT a FROM Artist a WHERE TRIM('X' FROM a.artistName) = 'A'");
        List objects = this.context.performQuery(query);
        Assert.assertEquals((long)2L, (long)objects.size());
        Assert.assertTrue((boolean)objects.contains(a1));
        Assert.assertTrue((boolean)objects.contains(a2));
        query = new EJBQLQuery("SELECT a FROM Artist a WHERE TRIM(LEADING 'X' FROM a.artistName) = 'A'");
        objects = this.context.performQuery(query);
        Assert.assertEquals((long)1L, (long)objects.size());
        Assert.assertTrue((boolean)objects.contains(a1));
        query = new EJBQLQuery("SELECT a FROM Artist a WHERE TRIM(TRAILING 'X' FROM a.artistName) = 'A'");
        objects = this.context.performQuery(query);
        Assert.assertEquals((long)1L, (long)objects.size());
        Assert.assertTrue((boolean)objects.contains(a2));
        query = new EJBQLQuery("SELECT a FROM Artist a WHERE TRIM(BOTH 'X' FROM a.artistName) = 'A'");
        objects = this.context.performQuery(query);
        Assert.assertEquals((long)2L, (long)objects.size());
        Assert.assertTrue((boolean)objects.contains(a1));
        Assert.assertTrue((boolean)objects.contains(a2));
    }
}

