/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.map;

import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ObjEntitySingleTableInheritanceTest {
    protected DataMap map;
    protected DbEntity dbEntity;
    protected DbAttribute dbAttribute1;
    protected DbAttribute dbAttribute2;
    protected DbAttribute dbAttribute3;
    protected DbRelationship dbRelationship1;
    protected DbRelationship dbRelationship2;
    protected DbRelationship dbRelationship3;
    protected ObjEntity entity1;
    protected ObjEntity entity2;
    protected ObjEntity entity3;
    protected ObjAttribute attribute1;
    protected ObjAttribute attribute2;
    protected ObjAttribute attribute3;
    protected ObjRelationship relationship1;
    protected ObjRelationship relationship2;
    protected ObjRelationship relationship3;

    @Before
    public void setUp() throws Exception {
        this.map = new DataMap();
        this.dbEntity = new DbEntity("DB");
        this.dbAttribute1 = new DbAttribute("ATTRIBUTE1", 4, this.dbEntity);
        this.dbAttribute2 = new DbAttribute("ATTRIBUTE2", 4, this.dbEntity);
        this.dbAttribute3 = new DbAttribute("ATTRIBUTE3", 4, this.dbEntity);
        this.dbEntity.addAttribute(this.dbAttribute1);
        this.dbEntity.addAttribute(this.dbAttribute2);
        this.dbEntity.addAttribute(this.dbAttribute3);
        this.dbRelationship1 = new DbRelationship("DBR1");
        this.dbRelationship2 = new DbRelationship("DBR2");
        this.dbRelationship3 = new DbRelationship("DBR3");
        this.dbEntity.addRelationship(this.dbRelationship1);
        this.dbEntity.addRelationship(this.dbRelationship2);
        this.dbEntity.addRelationship(this.dbRelationship3);
        this.map.addDbEntity(this.dbEntity);
        this.entity1 = new ObjEntity("e1");
        this.entity2 = new ObjEntity("e2");
        this.entity3 = new ObjEntity("e3");
        this.attribute1 = new ObjAttribute("a1");
        this.attribute2 = new ObjAttribute("a2");
        this.attribute3 = new ObjAttribute("a3");
        this.entity1.addAttribute(this.attribute1);
        this.entity2.addAttribute(this.attribute2);
        this.entity3.addAttribute(this.attribute3);
        this.relationship1 = new ObjRelationship("r1");
        this.relationship2 = new ObjRelationship("r2");
        this.relationship3 = new ObjRelationship("r3");
        this.entity1.addRelationship(this.relationship1);
        this.entity2.addRelationship(this.relationship2);
        this.entity3.addRelationship(this.relationship3);
        this.map.addObjEntity(this.entity1);
        this.map.addObjEntity(this.entity2);
        this.map.addObjEntity(this.entity3);
    }

    @Test
    public void testInheritedAttributes() throws Exception {
        Assert.assertSame((Object)this.attribute1, (Object)this.entity1.getAttribute("a1"));
        Assert.assertNull((Object)this.entity1.getAttribute("a2"));
        this.entity1.setSuperEntityName("e2");
        Assert.assertNotNull((Object)this.entity1.getAttribute("a2"));
        Assert.assertEquals((Object)"a2", (Object)this.entity1.getAttribute("a2").getName());
        Assert.assertSame((Object)this.entity1, (Object)this.entity1.getAttribute("a2").getParent());
        Assert.assertNull((Object)this.entity1.getAttribute("a3"));
        this.entity2.setSuperEntityName("e3");
        Assert.assertNotNull((Object)this.entity1.getAttribute("a3"));
    }

    @Test
    public void testInheritedRelationships() throws Exception {
        Assert.assertSame((Object)this.relationship1, (Object)this.entity1.getRelationship("r1"));
        Assert.assertNull((Object)this.entity1.getRelationship("r2"));
        this.entity1.setSuperEntityName("e2");
        Assert.assertSame((Object)this.relationship2, (Object)this.entity1.getRelationship("r2"));
        Assert.assertNull((Object)this.entity1.getRelationship("r3"));
        this.entity2.setSuperEntityName("e3");
        Assert.assertSame((Object)this.relationship3, (Object)this.entity1.getRelationship("r3"));
    }

    @Test
    public void testAttributeForDbAttribute() throws Exception {
        this.entity1.setSuperEntityName("e2");
        this.entity2.setDbEntityName(this.dbEntity.getName());
        this.attribute1.setDbAttributePath(this.dbAttribute1.getName());
        this.attribute2.setDbAttributePath(this.dbAttribute2.getName());
        Assert.assertNull((Object)this.entity2.getAttributeForDbAttribute(this.dbAttribute1));
        Assert.assertSame((Object)this.attribute2, (Object)this.entity2.getAttributeForDbAttribute(this.dbAttribute2));
        Assert.assertSame((Object)this.attribute1, (Object)this.entity1.getAttributeForDbAttribute(this.dbAttribute1));
        Assert.assertNotNull((Object)this.entity1.getAttributeForDbAttribute(this.dbAttribute2));
    }

    @Test
    public void testRelationshipForDbRelationship() throws Exception {
        this.entity1.setSuperEntityName("e2");
        this.entity2.setDbEntityName(this.dbEntity.getName());
        this.relationship1.addDbRelationship(this.dbRelationship1);
        this.relationship2.addDbRelationship(this.dbRelationship2);
        Assert.assertNull((Object)this.entity2.getRelationshipForDbRelationship(this.dbRelationship1));
        Assert.assertSame((Object)this.relationship2, (Object)this.entity2.getRelationshipForDbRelationship(this.dbRelationship2));
        Assert.assertSame((Object)this.relationship1, (Object)this.entity1.getRelationshipForDbRelationship(this.dbRelationship1));
        Assert.assertSame((Object)this.relationship2, (Object)this.entity1.getRelationshipForDbRelationship(this.dbRelationship2));
    }
}

