/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.map;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.map.EntityInheritanceTree;
import org.apache.cayenne.map.MappingNamespace;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.map.QueryDescriptor;
import org.apache.cayenne.map.SQLResult;

public class MockMappingNamespace
implements MappingNamespace {
    private Map<String, DbEntity> dbEntities = new HashMap<String, DbEntity>();
    private Map<String, ObjEntity> objEntities = new HashMap<String, ObjEntity>();
    private Map<String, QueryDescriptor> queryDescriptors = new HashMap<String, QueryDescriptor>();
    private Map<String, Procedure> procedures = new HashMap<String, Procedure>();

    @Override
    public Embeddable getEmbeddable(String className) {
        return null;
    }

    @Override
    public SQLResult getResult(String name) {
        return null;
    }

    public void addDbEntity(DbEntity entity) {
        this.dbEntities.put(entity.getName(), entity);
    }

    public void addObjEntity(ObjEntity entity) {
        this.objEntities.put(entity.getName(), entity);
    }

    public void addQueryDescriptor(QueryDescriptor queryDescriptor) {
        this.queryDescriptors.put(queryDescriptor.getName(), queryDescriptor);
    }

    public void addProcedure(Procedure procedure) {
        this.procedures.put(procedure.getName(), procedure);
    }

    @Override
    public DbEntity getDbEntity(String name) {
        return this.dbEntities.get(name);
    }

    @Override
    public ObjEntity getObjEntity(String name) {
        return this.objEntities.get(name);
    }

    @Override
    public Procedure getProcedure(String name) {
        return this.procedures.get(name);
    }

    @Override
    public QueryDescriptor getQueryDescriptor(String name) {
        return this.queryDescriptors.get(name);
    }

    @Override
    public Collection<DbEntity> getDbEntities() {
        return this.dbEntities.values();
    }

    @Override
    public Collection<ObjEntity> getObjEntities() {
        return this.objEntities.values();
    }

    @Override
    public Collection<Procedure> getProcedures() {
        return this.procedures.values();
    }

    @Override
    public Collection<QueryDescriptor> getQueryDescriptors() {
        return this.queryDescriptors.values();
    }

    @Override
    public Collection<Embeddable> getEmbeddables() {
        return null;
    }

    @Override
    public EntityInheritanceTree getInheritanceTree(String entityName) {
        return null;
    }

    @Override
    public ObjEntity getObjEntity(Class<?> entityClass) {
        return null;
    }

    @Override
    public Collection<SQLResult> getResults() {
        return null;
    }

    @Override
    public ObjEntity getObjEntity(Persistent object) {
        return null;
    }
}

