/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.datasource;

import java.sql.SQLException;
import org.apache.cayenne.datasource.PoolingDataSourceManager;
import org.apache.cayenne.datasource.UnmanagedPoolingDataSource;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class PoolDataSourceManagerTest {
    private UnmanagedPoolingDataSource mockPoolingDataSource;
    private PoolingDataSourceManager dataSourceManager;

    @Before
    public void before() throws SQLException {
        this.mockPoolingDataSource = (UnmanagedPoolingDataSource)Mockito.mock(UnmanagedPoolingDataSource.class);
        this.dataSourceManager = new PoolingDataSourceManager(this.mockPoolingDataSource, 100L);
    }

    @After
    public void after() {
        this.dataSourceManager.shutdown();
    }

    @Test
    public void testRun_Manage() throws InterruptedException {
        final int[] counter = new int[1];
        ((UnmanagedPoolingDataSource)Mockito.doAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                counter[0] = counter[0] + 1;
                return null;
            }
        }).when((Object)this.mockPoolingDataSource)).managePool();
        this.dataSourceManager.start();
        int c0 = counter[0];
        Assert.assertEquals((long)0L, (long)c0);
        Thread.sleep(300L);
        int c1 = counter[0];
        Assert.assertTrue((c1 > c0 ? 1 : 0) != 0);
        Thread.sleep(300L);
        int c2 = counter[0];
        Assert.assertTrue((c2 > c1 ? 1 : 0) != 0);
    }
}

