/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.ArrayList;
import java.util.List;
import org.apache.cayenne.DataObject;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.MockDataNode;
import org.apache.cayenne.cache.MapQueryCache;
import org.apache.cayenne.cache.QueryCache;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.QueryCacheStrategy;
import org.apache.cayenne.query.QueryMetadata;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class DataContextQueryCachingIT
extends ServerCase {
    @Inject
    protected DataContext context;
    @Inject
    protected DBHelper dbHelper;
    protected TableHelper tArtist;
    protected TableHelper tPainting;
    protected QueryCache oldCache;
    protected DataDomain domain;

    protected DataNode getNode() {
        return this.domain.getDataNodes().iterator().next();
    }

    @Before
    public void setUp() throws Exception {
        this.tArtist = new TableHelper(this.dbHelper, "ARTIST");
        this.tArtist.setColumns(new String[]{"ARTIST_ID", "ARTIST_NAME"});
        this.tPainting = new TableHelper(this.dbHelper, "PAINTING");
        this.tPainting.setColumns(new String[]{"PAINTING_ID", "PAINTING_TITLE", "ARTIST_ID", "ESTIMATED_PRICE"});
        this.domain = this.context.getParentDataDomain();
        this.oldCache = this.domain.getQueryCache();
        this.domain.setQueryCache(new MapQueryCache(50));
        this.context.setQueryCache(new MapQueryCache(50));
    }

    @After
    public void tearDown() throws Exception {
        this.domain.setQueryCache(this.oldCache);
    }

    protected void createInsertDataSet() throws Exception {
        this.tArtist.insert(new Object[]{33001, "aaa"});
        this.tPainting.insert(new Object[]{33001, "P", 33001, 4000});
    }

    protected void createUpdateDataSet1() throws Exception {
        this.tArtist.update().set("ARTIST_NAME", (Object)"bbb").where("ARTIST_ID", (Object)33001).execute();
    }

    protected void createUpdateDataSet2() throws Exception {
        this.tArtist.update().set("ARTIST_NAME", (Object)"ccc").where("ARTIST_ID", (Object)33001).execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLocalCacheDataRowsRefresh() throws Exception {
        SelectQuery<DataRow> select = SelectQuery.dataRowQuery(Artist.class);
        select.setCacheStrategy(QueryCacheStrategy.LOCAL_CACHE);
        MockDataNode engine = MockDataNode.interceptNode(this.domain, this.getNode());
        try {
            List<?> rows1 = this.mockupDataRows(2);
            engine.reset();
            engine.addExpectedResult(select, rows1);
            List resultRows = this.context.performQuery(select);
            Assert.assertEquals((long)1L, (long)engine.getRunCount());
            Assert.assertEquals(rows1, (Object)resultRows);
            QueryMetadata cacheKey = select.getMetaData(this.context.getEntityResolver());
            Assert.assertNull((Object)this.context.getParentDataDomain().getQueryCache().get(cacheKey));
            Assert.assertEquals(rows1, (Object)this.context.getQueryCache().get(cacheKey));
            List<?> rows2 = this.mockupDataRows(4);
            engine.reset();
            engine.addExpectedResult(select, rows2);
            select.setCacheStrategy(QueryCacheStrategy.LOCAL_CACHE_REFRESH);
            List freshResultRows = this.context.performQuery(select);
            Assert.assertEquals((long)1L, (long)engine.getRunCount());
            Assert.assertEquals(rows2, (Object)freshResultRows);
            Assert.assertNull((Object)this.context.getParentDataDomain().getQueryCache().get(cacheKey));
            Assert.assertEquals(rows2, (Object)this.context.getQueryCache().get(cacheKey));
        }
        finally {
            engine.stopInterceptNode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSharedCacheDataRowsRefresh() throws Exception {
        SelectQuery<DataRow> select = SelectQuery.dataRowQuery(Artist.class);
        select.setCacheStrategy(QueryCacheStrategy.SHARED_CACHE);
        MockDataNode engine = MockDataNode.interceptNode(this.domain, this.getNode());
        try {
            List<?> rows1 = this.mockupDataRows(2);
            engine.reset();
            engine.addExpectedResult(select, rows1);
            List resultRows = this.context.performQuery(select);
            Assert.assertEquals((long)1L, (long)engine.getRunCount());
            Assert.assertEquals(rows1, (Object)resultRows);
            QueryMetadata cacheKey = select.getMetaData(this.context.getEntityResolver());
            Assert.assertEquals(rows1, (Object)this.context.getParentDataDomain().getQueryCache().get(cacheKey));
            Assert.assertNull((Object)this.context.getQueryCache().get(cacheKey));
            List<?> rows2 = this.mockupDataRows(5);
            engine.reset();
            engine.addExpectedResult(select, rows2);
            select.setCacheStrategy(QueryCacheStrategy.SHARED_CACHE_REFRESH);
            List freshResultRows = this.context.performQuery(select);
            Assert.assertEquals((long)1L, (long)engine.getRunCount());
            Assert.assertEquals(rows2, (Object)freshResultRows);
            Assert.assertEquals(rows2, (Object)this.context.getParentDataDomain().getQueryCache().get(cacheKey));
            Assert.assertNull((Object)this.context.getQueryCache().get(cacheKey));
        }
        finally {
            engine.stopInterceptNode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLocalCacheDataObjectsRefresh() throws Exception {
        SelectQuery<Artist> select = new SelectQuery<Artist>(Artist.class);
        select.setCacheStrategy(QueryCacheStrategy.LOCAL_CACHE);
        MockDataNode engine = MockDataNode.interceptNode(this.domain, this.getNode());
        try {
            List<?> rows1 = this.mockupDataRows(2);
            engine.reset();
            engine.addExpectedResult(select, rows1);
            List resultRows = this.context.performQuery(select);
            Assert.assertEquals((long)1L, (long)engine.getRunCount());
            Assert.assertEquals((long)2L, (long)resultRows.size());
            Assert.assertTrue((boolean)(resultRows.get(0) instanceof DataObject));
            QueryMetadata cacheKey = select.getMetaData(this.context.getEntityResolver());
            Assert.assertNull((Object)this.context.getParentDataDomain().getQueryCache().get(cacheKey));
            Assert.assertEquals((Object)resultRows, (Object)this.context.getQueryCache().get(cacheKey));
            List<?> rows2 = this.mockupDataRows(4);
            engine.reset();
            engine.addExpectedResult(select, rows2);
            select.setCacheStrategy(QueryCacheStrategy.LOCAL_CACHE_REFRESH);
            List freshResultRows = this.context.performQuery(select);
            Assert.assertEquals((long)1L, (long)engine.getRunCount());
            Assert.assertEquals((long)4L, (long)freshResultRows.size());
            Assert.assertTrue((boolean)(resultRows.get(0) instanceof DataObject));
            Assert.assertNull((Object)this.context.getParentDataDomain().getQueryCache().get(cacheKey));
            Assert.assertEquals((Object)freshResultRows, (Object)this.context.getQueryCache().get(cacheKey));
        }
        finally {
            engine.stopInterceptNode();
        }
    }

    @Test
    public void testLocalCacheRefreshObjectsRefresh() throws Exception {
        this.createInsertDataSet();
        SelectQuery<Artist> select = new SelectQuery<Artist>(Artist.class);
        select.setCacheStrategy(QueryCacheStrategy.LOCAL_CACHE_REFRESH);
        List objects1 = this.context.performQuery(select);
        Assert.assertEquals((long)1L, (long)objects1.size());
        Artist a1 = (Artist)objects1.get(0);
        Assert.assertEquals((Object)"aaa", (Object)a1.getArtistName());
        this.createUpdateDataSet1();
        List objects2 = this.context.performQuery(select);
        Assert.assertEquals((long)1L, (long)objects2.size());
        Artist a2 = (Artist)objects2.get(0);
        Assert.assertSame((Object)a1, (Object)a2);
        Assert.assertEquals((Object)"bbb", (Object)a2.getArtistName());
    }

    private List<?> mockupDataRows(int len) {
        ArrayList<DataRow> rows = new ArrayList<DataRow>(len);
        for (int i = 0; i < len; ++i) {
            DataRow a = new DataRow(3);
            a.put("ARTIST_ID", i + 1);
            a.put("ARTIST_NAME", "A-" + (i + 1));
            rows.add(a);
        }
        return rows;
    }
}

