/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.List;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.testdo.compound.CompoundFkTestEntity;
import org.apache.cayenne.testdo.compound.CompoundPkTestEntity;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-compound.xml")
public class DataContextCompoundRelIT
extends ServerCase {
    @Inject
    private DataContext context;
    @Inject
    private DataContext context1;

    @Test
    public void testInsert() {
        CompoundPkTestEntity master = this.context.newObject(CompoundPkTestEntity.class);
        CompoundFkTestEntity detail = this.context.newObject(CompoundFkTestEntity.class);
        master.addToCompoundFkArray(detail);
        master.setName("m1");
        master.setKey1("key11");
        master.setKey2("key21");
        detail.setName("d1");
        this.context.commitChanges();
        this.context.invalidateObjects(master, detail);
        SelectQuery<CompoundPkTestEntity> q = SelectQuery.query(CompoundPkTestEntity.class);
        List<CompoundPkTestEntity> objs = q.select(this.context1);
        Assert.assertEquals((long)1L, (long)objs.size());
        Assert.assertEquals((Object)"m1", (Object)objs.get(0).getName());
        List<CompoundFkTestEntity> details = objs.get(0).getCompoundFkArray();
        Assert.assertEquals((long)1L, (long)details.size());
        Assert.assertEquals((Object)"d1", (Object)details.get(0).getName());
    }

    @Test
    public void testFetchQualifyingToOne() {
        CompoundPkTestEntity master = this.context.newObject(CompoundPkTestEntity.class);
        CompoundPkTestEntity master1 = this.context.newObject(CompoundPkTestEntity.class);
        CompoundFkTestEntity detail = this.context.newObject(CompoundFkTestEntity.class);
        CompoundFkTestEntity detail1 = this.context.newObject(CompoundFkTestEntity.class);
        master.addToCompoundFkArray(detail);
        master1.addToCompoundFkArray(detail1);
        master.setName("m1");
        master.setKey1("key11");
        master.setKey2("key21");
        master1.setName("m2");
        master1.setKey1("key12");
        master1.setKey2("key22");
        detail.setName("d1");
        detail1.setName("d2");
        this.context.commitChanges();
        this.context.invalidateObjects(master, master1, detail, detail1);
        Expression qual = ExpressionFactory.matchExp("toCompoundPk", (Object)master);
        SelectQuery<CompoundFkTestEntity> q = SelectQuery.query(CompoundFkTestEntity.class, qual);
        List<CompoundFkTestEntity> objs = q.select(this.context1);
        Assert.assertEquals((long)1L, (long)objs.size());
        Assert.assertEquals((Object)"d1", (Object)objs.get(0).getName());
    }

    @Test
    public void testFetchQualifyingToMany() {
        CompoundPkTestEntity master = this.context.newObject(CompoundPkTestEntity.class);
        CompoundPkTestEntity master1 = this.context.newObject(CompoundPkTestEntity.class);
        CompoundFkTestEntity detail = this.context.newObject(CompoundFkTestEntity.class);
        CompoundFkTestEntity detail1 = this.context.newObject(CompoundFkTestEntity.class);
        master.addToCompoundFkArray(detail);
        master1.addToCompoundFkArray(detail1);
        master.setName("m1");
        master.setKey1("key11");
        master.setKey2("key21");
        master1.setName("m2");
        master1.setKey1("key12");
        master1.setKey2("key22");
        detail.setName("d1");
        detail1.setName("d2");
        this.context.commitChanges();
        this.context.invalidateObjects(master, master1, detail, detail1);
        Expression qual = ExpressionFactory.matchExp("compoundFkArray", (Object)detail1);
        SelectQuery<CompoundPkTestEntity> q = SelectQuery.query(CompoundPkTestEntity.class, qual);
        List<CompoundPkTestEntity> objs = q.select(this.context1);
        Assert.assertEquals((long)1L, (long)objs.size());
        Assert.assertEquals((Object)"m2", (Object)objs.get(0).getName());
    }
}

