/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne;

import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.testdo.testmap.ArtGroup;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class CDOReflexiveRelIT
extends ServerCase {
    @Inject
    private ObjectContext context;

    @Test
    public void testAddDeleteNoCommit() {
        ArtGroup parentGroup = this.context.newObject(ArtGroup.class);
        parentGroup.setName("parent");
        ArtGroup childGroup1 = this.context.newObject(ArtGroup.class);
        childGroup1.setName("child1");
        childGroup1.setToParentGroup(parentGroup);
        this.context.deleteObjects(parentGroup);
    }

    @Test
    public void testAddDeleteWithCommit() {
        ArtGroup parentGroup = this.context.newObject(ArtGroup.class);
        parentGroup.setName("parent");
        ArtGroup childGroup1 = this.context.newObject(ArtGroup.class);
        childGroup1.setName("child1");
        childGroup1.setToParentGroup(parentGroup);
        this.context.commitChanges();
        this.context.deleteObjects(parentGroup);
        this.context.commitChanges();
    }

    @Test
    public void testReplaceDeleteNoCommit() {
        ArtGroup parentGroup1 = this.context.newObject(ArtGroup.class);
        parentGroup1.setName("parent1");
        ArtGroup parentGroup2 = this.context.newObject(ArtGroup.class);
        parentGroup2.setName("parent2");
        ArtGroup childGroup1 = this.context.newObject(ArtGroup.class);
        childGroup1.setName("child1");
        childGroup1.setToParentGroup(parentGroup1);
        childGroup1.setToParentGroup(parentGroup2);
        this.context.deleteObjects(parentGroup1);
        this.context.deleteObjects(parentGroup2);
    }

    @Test
    public void testReplaceDeleteWithCommit() {
        ArtGroup parentGroup1 = this.context.newObject(ArtGroup.class);
        parentGroup1.setName("parent1");
        ArtGroup parentGroup2 = this.context.newObject(ArtGroup.class);
        parentGroup2.setName("parent2");
        ArtGroup childGroup1 = this.context.newObject(ArtGroup.class);
        childGroup1.setName("child1");
        childGroup1.setToParentGroup(parentGroup1);
        childGroup1.setToParentGroup(parentGroup2);
        this.context.commitChanges();
        this.context.deleteObjects(parentGroup1);
        this.context.deleteObjects(parentGroup2);
        this.context.commitChanges();
    }

    @Test
    public void testCommitReplaceCommit() {
        ArtGroup parentGroup1 = this.context.newObject(ArtGroup.class);
        parentGroup1.setName("parent1");
        ArtGroup parentGroup2 = this.context.newObject(ArtGroup.class);
        parentGroup2.setName("parent2");
        ArtGroup childGroup1 = this.context.newObject(ArtGroup.class);
        childGroup1.setName("child1");
        childGroup1.setToParentGroup(parentGroup1);
        this.context.commitChanges();
        childGroup1.setToParentGroup(parentGroup2);
        this.context.commitChanges();
    }

    @Test
    public void testComplexInsertUpdateOrdering() {
        ArtGroup parentGroup = this.context.newObject(ArtGroup.class);
        parentGroup.setName("parent");
        this.context.commitChanges();
        ArtGroup childGroup1 = this.context.newObject(ArtGroup.class);
        childGroup1.setName("child1");
        childGroup1.setToParentGroup(parentGroup);
        this.context.commitChanges();
        childGroup1.setToParentGroup(null);
        this.context.commitChanges();
    }
}

