/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.ValueHolder;
import org.apache.cayenne.util.PersistentObjectCollection;
import org.apache.cayenne.util.RelationshipFault;
import org.apache.cayenne.util.Util;

public class PersistentObjectList<E>
extends RelationshipFault<E>
implements List<E>,
ValueHolder<List<E>>,
PersistentObjectCollection<E> {
    protected List<E> objectList;
    protected LinkedList<E> addedToUnresolved;
    protected LinkedList<E> removedFromUnresolved;

    private PersistentObjectList() {
    }

    public PersistentObjectList(Persistent relationshipOwner, String relationshipName) {
        super(relationshipOwner, relationshipName);
    }

    @Override
    public boolean isFault() {
        if (this.objectList != null) {
            return false;
        }
        if (this.isTransientParent()) {
            this.objectList = new LinkedList();
            return false;
        }
        return true;
    }

    @Override
    public void invalidate() {
        this.setObjectList(null);
    }

    @Override
    public List<E> setValueDirectly(List<E> value) throws CayenneRuntimeException {
        List<E> old = this.objectList;
        this.setObjectList(value);
        return old;
    }

    @Override
    public List<E> getValue() throws CayenneRuntimeException {
        return this.resolvedObjectList();
    }

    @Override
    public List<E> getValueDirectly() throws CayenneRuntimeException {
        return this.objectList;
    }

    @Override
    public List<E> setValue(List<E> value) throws CayenneRuntimeException {
        this.resolvedObjectList();
        return this.setValueDirectly(value);
    }

    public void setObjectList(List<E> objectList) {
        this.objectList = objectList;
    }

    @Override
    public boolean add(E o) {
        if (this.isFault() ? this.addLocal(o) : this.objectList.add(o)) {
            this.postprocessAdd(o);
            return true;
        }
        return false;
    }

    @Override
    public void add(int index, E o) {
        this.resolvedObjectList().add(index, o);
        this.postprocessAdd(o);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        if (this.resolvedObjectList().addAll(c)) {
            this.postprocessAdd((E)c);
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        if (this.resolvedObjectList().addAll(index, c)) {
            this.postprocessAdd((E)c);
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        List<E> resolved = this.resolvedObjectList();
        this.postprocessRemove((E)resolved);
        resolved.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.resolvedObjectList().contains(o);
    }

    @Override
    public boolean containsAll(Collection c) {
        return this.resolvedObjectList().containsAll(c);
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof PersistentObjectList)) {
            return false;
        }
        return this.resolvedObjectList().equals(((PersistentObjectList)o).resolvedObjectList());
    }

    @Override
    public int hashCode() {
        return 37 + this.resolvedObjectList().hashCode();
    }

    @Override
    public E get(int index) {
        return this.resolvedObjectList().get(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.resolvedObjectList().indexOf(o);
    }

    @Override
    public boolean isEmpty() {
        return this.resolvedObjectList().isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return this.resolvedObjectList().iterator();
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.resolvedObjectList().lastIndexOf(o);
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.resolvedObjectList().listIterator();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return this.resolvedObjectList().listIterator(index);
    }

    @Override
    public E remove(int index) {
        E removed = this.resolvedObjectList().remove(index);
        this.postprocessRemove(removed);
        return removed;
    }

    @Override
    public boolean remove(Object o) {
        if (this.isFault() ? this.removeLocal(o) : this.objectList.remove(o)) {
            this.postprocessRemove(o);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (this.resolvedObjectList().removeAll(c)) {
            this.postprocessRemove((E)c);
            return true;
        }
        return false;
    }

    @Override
    public boolean retainAll(Collection c) {
        return this.resolvedObjectList().retainAll(c);
    }

    @Override
    public E set(int index, E o) {
        E oldValue = this.resolvedObjectList().set(index, o);
        this.postprocessAdd(o);
        this.postprocessRemove(oldValue);
        return oldValue;
    }

    @Override
    public int size() {
        return this.resolvedObjectList().size();
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return this.resolvedObjectList().subList(fromIndex, toIndex);
    }

    @Override
    public Object[] toArray() {
        return this.resolvedObjectList().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.resolvedObjectList().toArray(a);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<E> resolvedObjectList() {
        if (this.isFault()) {
            PersistentObjectList persistentObjectList = this;
            synchronized (persistentObjectList) {
                if (this.isFault()) {
                    this.objectList = this.resolveFromDB();
                }
            }
        }
        return this.objectList;
    }

    protected void clearLocalChanges() {
        this.addedToUnresolved = null;
        this.removedFromUnresolved = null;
    }

    @Override
    protected void mergeLocalChanges(List<E> fetchedList) {
        if (this.isUncommittedParent()) {
            if (this.removedFromUnresolved != null) {
                fetchedList.removeAll(this.removedFromUnresolved);
            }
            if (this.addedToUnresolved != null && !this.addedToUnresolved.isEmpty()) {
                for (Object next : this.addedToUnresolved) {
                    Persistent dataObject;
                    if (next instanceof Persistent && (dataObject = (Persistent)next).getPersistenceState() == 1 || fetchedList.contains(next)) continue;
                    fetchedList.add(next);
                }
            }
        }
        this.clearLocalChanges();
    }

    protected boolean addLocal(E object) {
        if (this.removedFromUnresolved != null) {
            this.removedFromUnresolved.remove(object);
        }
        if (this.addedToUnresolved == null) {
            this.addedToUnresolved = new LinkedList();
        }
        this.addedToUnresolved.addLast(object);
        return true;
    }

    protected boolean removeLocal(E object) {
        if (this.addedToUnresolved != null) {
            this.addedToUnresolved.remove(object);
        }
        if (this.removedFromUnresolved == null) {
            this.removedFromUnresolved = new LinkedList();
        }
        if (this.shouldAddToRemovedFromUnresolvedList(object)) {
            this.removedFromUnresolved.addLast(object);
        }
        return true;
    }

    protected boolean shouldAddToRemovedFromUnresolvedList(Object object) {
        return true;
    }

    protected void postprocessAdd(Collection<? extends E> collection) {
        for (E next : collection) {
            this.postprocessAdd(next);
        }
    }

    protected void postprocessRemove(Collection<? extends E> collection) {
        for (E next : collection) {
            this.postprocessRemove(next);
        }
    }

    protected void postprocessAdd(E addedObject) {
        if (this.relationshipOwner.getObjectContext() != null) {
            this.relationshipOwner.getObjectContext().propertyChanged(this.relationshipOwner, this.relationshipName, null, addedObject);
            if (addedObject instanceof Persistent) {
                Util.setReverse(this.relationshipOwner, this.relationshipName, (Persistent)addedObject);
            }
        }
    }

    protected void postprocessRemove(E removedObject) {
        if (this.relationshipOwner.getObjectContext() != null) {
            this.relationshipOwner.getObjectContext().propertyChanged(this.relationshipOwner, this.relationshipName, removedObject, null);
            if (removedObject instanceof Persistent) {
                Util.unsetReverse(this.relationshipOwner, this.relationshipName, (Persistent)removedObject);
            }
        }
    }

    public String toString() {
        return this.objectList != null ? this.objectList.toString() : "[<unresolved>]";
    }

    @Override
    public void addDirectly(E target) {
        if (this.isFault()) {
            this.addLocal(target);
        } else {
            this.objectList.add(target);
        }
    }

    @Override
    public void removeDirectly(E target) {
        if (this.isFault()) {
            this.removeLocal(target);
        } else {
            this.objectList.remove(target);
        }
    }
}

