/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.configuration.xml;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.cayenne.ConfigurationException;
import org.apache.cayenne.configuration.PasswordEncoding;
import org.apache.cayenne.configuration.xml.DataNodeChildrenHandler;
import org.apache.cayenne.configuration.xml.NamespaceAwareNestedTagHandler;
import org.apache.cayenne.configuration.xml.XMLDataChannelDescriptorLoader;
import org.apache.cayenne.conn.DataSourceInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;

class DataSourceChildrenHandler
extends NamespaceAwareNestedTagHandler {
    private static final Logger logger = LoggerFactory.getLogger(XMLDataChannelDescriptorLoader.class);
    static final String DRIVER_TAG = "driver";
    static final String LOGIN_TAG = "login";
    static final String URL_TAG = "url";
    static final String CONNECTION_POOL_TAG = "connectionPool";
    private XMLDataChannelDescriptorLoader xmlDataChannelDescriptorLoader;
    private DataSourceInfo dataSourceDescriptor;

    DataSourceChildrenHandler(XMLDataChannelDescriptorLoader xmlDataChannelDescriptorLoader, DataNodeChildrenHandler parentHandler, DataSourceInfo dataSourceDescriptor) {
        super(parentHandler);
        this.xmlDataChannelDescriptorLoader = xmlDataChannelDescriptorLoader;
        this.dataSourceDescriptor = dataSourceDescriptor;
    }

    @Override
    protected boolean processElement(String namespaceURI, String localName, Attributes attributes) {
        switch (localName) {
            case "driver": {
                this.dataSourceDescriptor.setJdbcDriver(attributes.getValue("value"));
                return true;
            }
            case "login": {
                this.configureCredentials(attributes);
                return true;
            }
            case "url": {
                this.dataSourceDescriptor.setDataSourceUrl(attributes.getValue("value"));
                return true;
            }
            case "connectionPool": {
                this.configureConnectionPool(attributes);
                return true;
            }
        }
        return false;
    }

    void configureCredentials(Attributes attributes) {
        String encoderClass = attributes.getValue("encoderClass");
        String encoderKey = attributes.getValue("encoderKey");
        if (encoderKey == null) {
            encoderKey = attributes.getValue("encoderSalt");
        }
        String password = attributes.getValue("password");
        String passwordLocation = attributes.getValue("passwordLocation");
        String passwordSource = attributes.getValue("passwordSource");
        if (passwordSource == null) {
            passwordSource = "model";
        }
        String username = attributes.getValue("userName");
        this.dataSourceDescriptor.setPasswordEncoderClass(encoderClass);
        this.dataSourceDescriptor.setPasswordEncoderKey(encoderKey);
        this.dataSourceDescriptor.setPasswordLocation(passwordLocation);
        this.dataSourceDescriptor.setPasswordSource(passwordSource);
        this.dataSourceDescriptor.setUserName(username);
        if (encoderKey != null) {
            passwordSource = passwordSource.replaceAll("\\{\\}", encoderKey);
        }
        String encoderType = this.dataSourceDescriptor.getPasswordEncoderClass();
        PasswordEncoding passwordEncoder = null;
        if (encoderType != null) {
            passwordEncoder = (PasswordEncoding)this.xmlDataChannelDescriptorLoader.objectFactory.newInstance(PasswordEncoding.class, encoderType);
        }
        if (passwordLocation != null) {
            switch (passwordLocation) {
                case "classpath": {
                    ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                    URL url = classLoader.getResource(username);
                    if (url != null) {
                        password = XMLDataChannelDescriptorLoader.passwordFromURL(url);
                        break;
                    }
                    logger.error("Could not find resource in CLASSPATH: " + passwordSource);
                    break;
                }
                case "url": {
                    try {
                        password = XMLDataChannelDescriptorLoader.passwordFromURL(new URL(passwordSource));
                    }
                    catch (MalformedURLException exception) {
                        logger.warn(exception.getMessage(), (Throwable)exception);
                    }
                    break;
                }
                case "executable": {
                    if (passwordSource == null) break;
                    try {
                        Process process = Runtime.getRuntime().exec(passwordSource);
                        password = XMLDataChannelDescriptorLoader.passwordFromInputStream(process.getInputStream());
                        process.waitFor();
                        break;
                    }
                    catch (IOException | InterruptedException exception) {
                        logger.warn(exception.getMessage(), (Throwable)exception);
                    }
                }
            }
        }
        if (password != null && passwordEncoder != null) {
            this.dataSourceDescriptor.setPassword(passwordEncoder.decodePassword(password, encoderKey));
        }
    }

    void configureConnectionPool(Attributes attributes) {
        String max;
        String min = attributes.getValue("min");
        if (min != null) {
            try {
                this.dataSourceDescriptor.setMinConnections(Integer.parseInt(min));
            }
            catch (NumberFormatException nfex) {
                logger.info("Non-numeric 'min' attribute", (Throwable)nfex);
                throw new ConfigurationException("Non-numeric 'min' attribute '%s'", (Throwable)nfex, min);
            }
        }
        if ((max = attributes.getValue("max")) != null) {
            try {
                this.dataSourceDescriptor.setMaxConnections(Integer.parseInt(max));
            }
            catch (NumberFormatException nfex) {
                logger.info("Non-numeric 'max' attribute", (Throwable)nfex);
                throw new ConfigurationException("Non-numeric 'max' attribute '%s'", (Throwable)nfex, max);
            }
        }
    }
}

