/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.map;

import org.apache.cayenne.di.Inject;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.EntityInheritanceTree;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.unit.di.server.PeopleProjectCase;
import org.junit.Assert;
import org.junit.Test;

public class EntityResolverInheritanceIT
extends PeopleProjectCase {
    @Inject
    private EntityResolver resolver;

    @Test
    public void testGetAbstractPersonTree() throws Exception {
        EntityInheritanceTree tree = this.resolver.getInheritanceTree("AbstractPerson");
        Assert.assertNotNull((Object)tree);
        Assert.assertEquals((long)2L, (long)tree.getChildrenCount());
        Assert.assertSame((Object)this.resolver.getObjEntity("AbstractPerson"), (Object)tree.getEntity());
    }

    @Test
    public void testGetEmployeeTree() throws Exception {
        EntityInheritanceTree tree = this.resolver.getInheritanceTree("Employee");
        Assert.assertNotNull((Object)tree);
        Assert.assertEquals((long)1L, (long)tree.getChildrenCount());
        Assert.assertSame((Object)this.resolver.getObjEntity("Employee"), (Object)tree.getEntity());
    }

    @Test
    public void testGetManagerTree() throws Exception {
        EntityInheritanceTree tree = this.resolver.getInheritanceTree("Manager");
        Assert.assertNotNull((Object)tree);
        Assert.assertEquals((long)0L, (long)tree.getChildrenCount());
    }

    @Test
    public void testLookupTreeRefresh() throws Exception {
        ObjEntity super1 = new ObjEntity("super1");
        ObjEntity sub1 = new ObjEntity("sub1");
        ObjEntity sub2 = new ObjEntity("sub2");
        super1.setClassName("java.lang.Float");
        sub1.setSuperEntityName("super1");
        sub1.setClassName("java.lang.Object");
        sub2.setSuperEntityName("super1");
        sub2.setClassName("java.lang.Integer");
        DataMap map = new DataMap("test");
        map.addObjEntity(super1);
        map.addObjEntity(sub1);
        map.addObjEntity(sub2);
        Assert.assertNull((Object)this.resolver.getInheritanceTree("super1"));
        this.resolver.addDataMap(map);
        EntityInheritanceTree tree = this.resolver.getInheritanceTree("super1");
        Assert.assertNotNull((Object)tree);
        Assert.assertEquals((long)2L, (long)tree.getChildrenCount());
        Assert.assertSame((Object)super1, (Object)tree.getEntity());
    }
}

