/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp;

import java.util.Arrays;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.exp.TstTraversalHandler;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ExpressionTraversalTest {
    private TstTraversalHandler handler;

    @Before
    public void setUp() throws Exception {
        this.handler = new TstTraversalHandler();
    }

    @Test
    public void testUnary_Negative1() {
        this.doExpressionTest("-5", 1, 1);
    }

    @Test
    public void testUnary_Negative2() {
        this.doExpressionTest("-estimatedPrice", 2, 1);
    }

    @Test
    public void testUnary_Negative3() {
        this.doExpressionTest("-toGallery.paintingArray.estimatedPrice", 2, 1);
    }

    @Test
    public void testBinary_In1() {
        this.doExpressionTest("toGallery.galleryName in ('g1', 'g2', 'g3')", 3, 2);
    }

    @Test
    public void testBinary_In2() {
        Expression exp = ExpressionFactory.inExp("toGallery.galleryName", Arrays.asList("g1", "g2", "g3"));
        this.doExpressionTest(exp, 3, 2);
    }

    @Test
    public void testBinary_In3() {
        Expression exp = ExpressionFactory.inExp("toGallery.galleryName", "g1", "g2", "g3");
        this.doExpressionTest(exp, 3, 2);
    }

    @Test
    public void testBinary_Like() {
        this.doExpressionTest("toGallery.galleryName like 'a%'", 2, 2);
    }

    @Test
    public void testBinary_LikeIgnoreCase() {
        this.doExpressionTest("toGallery.galleryName likeIgnoreCase 'a%'", 2, 2);
    }

    @Test
    public void testBinary_IsNull() {
        this.doExpressionTest("toGallery.galleryName = null", 2, 2);
    }

    @Test
    public void testBinary_IsNotNull() {
        this.doExpressionTest("toGallery.galleryName != null", 2, 2);
    }

    @Test
    public void testTernary_Between() {
        this.doExpressionTest("estimatedPrice between 3000 and 15000", 2, 3);
    }

    private void doExpressionTest(String expression, int totalNodes, int totalLeaves) {
        this.doExpressionTest(ExpressionFactory.exp(expression, new Object[0]), totalNodes, totalLeaves);
    }

    private void doExpressionTest(Expression expression, int totalNodes, int totalLeaves) {
        this.handler.reset();
        expression.traverse(this.handler);
        this.handler.assertConsistency();
        Assert.assertEquals((long)totalNodes, (long)this.handler.getNodeCount());
        Assert.assertEquals((long)totalLeaves, (long)this.handler.getLeafs());
    }
}

