/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.event;

import org.apache.cayenne.event.EventSubject;
import org.apache.cayenne.util.Util;
import org.junit.Assert;
import org.junit.Test;

public class EventSubjectTest {
    @Test
    public void testIllegalArguments() {
        try {
            EventSubject.getSubject(null, "Subject");
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            EventSubject.getSubject(Object.class, null);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            EventSubject.getSubject(Object.class, "");
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testEqualityOfClonedSubjects() throws Exception {
        EventSubject s1 = EventSubject.getSubject(EventSubjectTest.class, "MySubject");
        EventSubject s2 = Util.cloneViaSerialization(s1);
        Assert.assertNotSame((Object)s1, (Object)s2);
        Assert.assertEquals((Object)s1, (Object)s2);
        Assert.assertEquals((long)s1.hashCode(), (long)s2.hashCode());
    }

    @Test
    public void testIdenticalSubject() {
        EventSubject s1 = EventSubject.getSubject(EventSubjectTest.class, "MySubject");
        EventSubject s2 = EventSubject.getSubject(EventSubjectTest.class, "MySubject");
        Assert.assertSame((Object)s1, (Object)s2);
    }

    @Test
    public void testEqualityOfIdenticalSubjects() {
        EventSubject s1 = EventSubject.getSubject(EventSubjectTest.class, "MySubject");
        EventSubject s2 = EventSubject.getSubject(EventSubjectTest.class, "MySubject");
        Assert.assertEquals((Object)s1, (Object)s2);
    }

    @Test
    public void testEqualityOfSubjectsByDifferentOwner() {
        EventSubject s1 = EventSubject.getSubject(EventSubject.class, "MySubject");
        EventSubject s2 = EventSubject.getSubject(EventSubjectTest.class, "MySubject");
        Assert.assertFalse((boolean)s1.equals(s2));
    }

    @Test
    public void testEqualityOfSubjectsByDifferentTopic() {
        EventSubject s1 = EventSubject.getSubject(EventSubjectTest.class, "Subject1");
        EventSubject s2 = EventSubject.getSubject(EventSubjectTest.class, "Subject2");
        Assert.assertFalse((boolean)s1.equals(s2));
    }

    @Test
    public void testSubjectEqualsNull() {
        EventSubject s1 = EventSubject.getSubject(EventSubjectTest.class, "MySubject");
        Assert.assertFalse((boolean)s1.equals(null));
    }
}

