/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.configuration.xml;

import java.util.Objects;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.configuration.xml.LoaderContext;
import org.apache.cayenne.configuration.xml.NamespaceAwareNestedTagHandler;
import org.apache.cayenne.util.LocalizedStringsHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public abstract class VersionAwareHandler
extends NamespaceAwareNestedTagHandler {
    protected String rootTag;

    public VersionAwareHandler(LoaderContext loaderContext, String rootTag) {
        super(loaderContext);
        this.setAllowAllNamespaces(true);
        this.rootTag = Objects.requireNonNull(rootTag);
    }

    @Override
    protected boolean processElement(String namespaceURI, String localName, Attributes attributes) throws SAXException {
        if (!this.rootTag.equals(localName)) {
            throw new CayenneRuntimeException("Illegal XML root tag: %s, expected: %s", localName, this.rootTag);
        }
        this.validateVersion(attributes);
        this.validateNamespace(namespaceURI);
        return false;
    }

    protected void validateVersion(Attributes attributes) {
        String version = attributes.getValue("project-version");
        if (!"10".equals(version)) {
            throw new CayenneRuntimeException("Unsupported project version: %s, please upgrade project using Modeler or include cayenne-project-compatibility module v%s", version, LocalizedStringsHandler.getString("cayenne.version"));
        }
    }

    protected void validateNamespace(String realNamespace) {
        if (!this.targetNamespace.equals(realNamespace)) {
            throw new CayenneRuntimeException("Unknown XML namespace %s, expected %s. Probably xml was modified.", realNamespace, this.targetNamespace);
        }
    }
}

