/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.configuration.server;

import java.sql.Connection;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.configuration.server.ServerRuntime;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.tx.Transaction;
import org.apache.cayenne.tx.TransactionListener;
import org.apache.cayenne.tx.TransactionalOperation;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.apache.cayenne.validation.ValidationException;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@UseServerRuntime(value="cayenne-testmap.xml")
public class ServerRuntimeIT
extends ServerCase {
    @Inject
    private ServerRuntime runtime;
    @Inject
    private ObjectContext context;

    @Test
    public void testPerformInTransaction_Local_Callback() {
        TransactionListener callback = (TransactionListener)Mockito.mock(TransactionListener.class);
        Artist a = this.runtime.performInTransaction(new TransactionalOperation<Artist>(){

            @Override
            public Artist perform() {
                Artist localArtist = ServerRuntimeIT.this.runtime.newContext().newObject(Artist.class);
                localArtist.setArtistName("A1");
                localArtist.getObjectContext().commitChanges();
                return localArtist;
            }
        }, callback);
        Assert.assertEquals((Object)"A1", (Object)a.getArtistName());
        Assert.assertEquals((long)3L, (long)a.getPersistenceState());
        ((TransactionListener)Mockito.verify((Object)callback)).willCommit((Transaction)ArgumentMatchers.any(Transaction.class));
        ((TransactionListener)Mockito.verify((Object)callback)).willAddConnection((Transaction)ArgumentMatchers.any(Transaction.class), (String)ArgumentMatchers.any(String.class), (Connection)ArgumentMatchers.any(Connection.class));
        ((TransactionListener)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)0))).willRollback((Transaction)ArgumentMatchers.any(Transaction.class));
    }

    @Test
    public void testPerformInTransaction_Local_Callback_Rollback() {
        TransactionListener callback = (TransactionListener)Mockito.mock(TransactionListener.class);
        try {
            this.runtime.performInTransaction(new TransactionalOperation<Artist>(){

                @Override
                public Artist perform() {
                    Artist localArtist = ServerRuntimeIT.this.runtime.newContext().newObject(Artist.class);
                    localArtist.getObjectContext().commitChanges();
                    return localArtist;
                }
            }, callback);
            Assert.fail((String)"Exception expected");
        }
        catch (ValidationException v) {
            ((TransactionListener)Mockito.verify((Object)callback)).willRollback((Transaction)ArgumentMatchers.any(Transaction.class));
            ((TransactionListener)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)0))).willAddConnection((Transaction)ArgumentMatchers.any(Transaction.class), (String)ArgumentMatchers.any(String.class), (Connection)ArgumentMatchers.any(Connection.class));
            ((TransactionListener)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)0))).willCommit((Transaction)ArgumentMatchers.any(Transaction.class));
        }
    }

    @Test
    public void testRollbackTransaction() {
        Assert.assertEquals((long)0L, (long)ObjectSelect.query(Artist.class).selectCount(this.context));
        try {
            this.runtime.performInTransaction(new TransactionalOperation<Object>(){

                @Override
                public Object perform() {
                    for (int i = 0; i < 30; ++i) {
                        Artist artist = ServerRuntimeIT.this.context.newObject(Artist.class);
                        artist.setArtistName("test" + i);
                        ServerRuntimeIT.this.context.commitChanges();
                    }
                    ServerRuntimeIT.this.context.newObject(Artist.class);
                    ServerRuntimeIT.this.context.commitChanges();
                    return null;
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertEquals((long)0L, (long)ObjectSelect.query(Artist.class).selectCount(this.context));
    }
}

