/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.CayenneException;
import org.apache.cayenne.ResultIterator;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.OperationObserver;
import org.apache.cayenne.access.jdbc.ConnectionAwareResultIterator;
import org.apache.cayenne.access.jdbc.JDBCResultIterator;
import org.apache.cayenne.access.jdbc.LimitResultIterator;
import org.apache.cayenne.access.jdbc.RowDescriptorBuilder;
import org.apache.cayenne.access.jdbc.SQLStatement;
import org.apache.cayenne.access.jdbc.reader.RowReader;
import org.apache.cayenne.access.translator.ParameterBinding;
import org.apache.cayenne.access.types.ExtendedType;
import org.apache.cayenne.access.types.ExtendedTypeMap;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dba.TypesMapping;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.QueryMetadata;
import org.apache.cayenne.query.SQLAction;
import org.apache.cayenne.query.SQLTemplate;
import org.apache.cayenne.util.Util;

public class SQLTemplateAction
implements SQLAction {
    protected SQLTemplate query;
    protected QueryMetadata queryMetadata;
    protected DbEntity dbEntity;
    protected DataNode dataNode;
    protected DbAdapter dbAdapter;

    public SQLTemplateAction(SQLTemplate query, DataNode dataNode) {
        this.query = query;
        this.dataNode = dataNode;
        this.queryMetadata = query.getMetaData(dataNode.getEntityResolver());
        this.dbEntity = this.queryMetadata.getDbEntity();
        this.dbAdapter = dataNode.getAdapter().unwrap();
    }

    public DbAdapter getAdapter() {
        return this.dbAdapter;
    }

    @Override
    public void performAction(Connection connection, OperationObserver callback) throws SQLException, Exception {
        String template = this.extractTemplateString();
        if (template == null) {
            throw new CayenneException("No template string configured for adapter " + this.dbAdapter.getClass().getName(), new Object[0]);
        }
        boolean loggable = this.dataNode.getJdbcEventLogger().isLoggable();
        ArrayList<Number> counts = new ArrayList<Number>();
        if (this.query.getPositionalParams().isEmpty()) {
            this.runWithNamedParametersBatch(connection, callback, template, counts, loggable);
        } else {
            this.runWithPositionalParameters(connection, callback, template, counts, loggable);
        }
        int[] ints = new int[counts.size()];
        for (int i = 0; i < ints.length; ++i) {
            ints[i] = ((Number)counts.get(i)).intValue();
        }
        callback.nextBatchCount(this.query, ints);
    }

    private void bindExtendedTypes(ParameterBinding[] bindings) {
        int i = 1;
        for (ParameterBinding binding : bindings) {
            Object value = binding.getValue();
            ExtendedType extendedType = value != null ? this.getAdapter().getExtendedTypes().getRegisteredType(value.getClass()) : this.getAdapter().getExtendedTypes().getDefaultType();
            binding.setExtendedType(extendedType);
            binding.setStatementPosition(i++);
        }
    }

    private void runWithPositionalParameters(Connection connection, OperationObserver callback, String template, Collection<Number> counts, boolean loggable) throws Exception {
        SQLStatement compiled = this.dataNode.getSqlTemplateProcessor().processTemplate(template, this.query.getPositionalParams());
        this.bindExtendedTypes(compiled.getBindings());
        if (loggable) {
            this.dataNode.getJdbcEventLogger().logQuery(compiled.getSql(), compiled.getBindings());
        }
        this.execute(connection, callback, compiled, counts);
    }

    private void runWithNamedParametersBatch(Connection connection, OperationObserver callback, String template, Collection<Number> counts, boolean loggable) throws Exception {
        Iterator<Map<String, Object>> it;
        int batchSize;
        int size = this.query.parametersSize();
        int n = batchSize = size > 0 ? size : 1;
        if (size == 0) {
            Iterator empty = Collections.singleton(Collections.emptyMap()).iterator();
            it = empty;
        } else {
            it = this.query.parametersIterator();
        }
        for (int i = 0; i < batchSize; ++i) {
            Map<String, Object> nextParameters = it.next();
            SQLStatement compiled = this.dataNode.getSqlTemplateProcessor().processTemplate(template, nextParameters);
            this.bindExtendedTypes(compiled.getBindings());
            if (loggable) {
                this.dataNode.getJdbcEventLogger().logQuery(compiled.getSql(), compiled.getBindings());
            }
            this.execute(connection, callback, compiled, counts);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute(Connection connection, OperationObserver callback, SQLStatement compiled, Collection<Number> updateCounts) throws SQLException, Exception {
        long t1 = System.currentTimeMillis();
        boolean iteratedResult = callback.isIteratedResult();
        int generatedKeys = this.query.isReturnGeneratedKeys() ? 1 : 2;
        PreparedStatement statement = connection.prepareStatement(compiled.getSql(), generatedKeys);
        try {
            ResultSet generatedKeysResultSet;
            this.bind(statement, compiled.getBindings());
            boolean isResultSet = statement.execute();
            if (this.query.isReturnGeneratedKeys() && (generatedKeysResultSet = statement.getGeneratedKeys()) != null) {
                this.processSelectResult(compiled, connection, statement, generatedKeysResultSet, callback, t1);
            }
            boolean firstIteration = true;
            while (true) {
                if (firstIteration) {
                    firstIteration = false;
                } else {
                    isResultSet = statement.getMoreResults();
                }
                if (isResultSet) {
                    ResultSet resultSet = statement.getResultSet();
                    if (resultSet == null) continue;
                    try {
                        this.processSelectResult(compiled, connection, statement, resultSet, callback, t1);
                    }
                    finally {
                        if (!iteratedResult) {
                            resultSet.close();
                        }
                    }
                    if (!iteratedResult) continue;
                    break;
                }
                int updateCount = statement.getUpdateCount();
                if (updateCount == -1) {
                    break;
                }
                updateCounts.add(updateCount);
                this.dataNode.getJdbcEventLogger().logUpdateCount(updateCount);
            }
        }
        finally {
            if (!iteratedResult) {
                statement.close();
            }
        }
    }

    protected void processSelectResult(SQLStatement compiled, Connection connection, Statement statement, ResultSet resultSet, OperationObserver callback, final long startTime) throws Exception {
        boolean iteratedResult = callback.isIteratedResult();
        ExtendedTypeMap types = this.dataNode.getAdapter().getExtendedTypes();
        RowDescriptorBuilder builder = this.configureRowDescriptorBuilder(compiled, resultSet);
        RowReader<?> rowReader = this.dataNode.rowReader(builder.getDescriptor(types), this.queryMetadata);
        ResultIterator<Object> it = new JDBCResultIterator(statement, resultSet, rowReader);
        if (iteratedResult) {
            it = new ConnectionAwareResultIterator(it, connection){

                @Override
                protected void doClose() {
                    SQLTemplateAction.this.dataNode.getJdbcEventLogger().logSelectCount(this.rowCounter, System.currentTimeMillis() - startTime);
                    super.doClose();
                }
            };
        }
        it = new LimitResultIterator(it, this.getFetchOffset(), this.query.getFetchLimit());
        if (iteratedResult) {
            try {
                callback.nextRows((Query)this.query, it);
            }
            catch (Exception ex) {
                it.close();
                throw ex;
            }
        } else {
            List<Object> resultRows = it.allRows();
            this.dataNode.getJdbcEventLogger().logSelectCount(resultRows.size(), System.currentTimeMillis() - startTime);
            callback.nextRows((Query)this.query, resultRows);
        }
    }

    protected RowDescriptorBuilder configureRowDescriptorBuilder(SQLStatement compiled, ResultSet resultSet) throws SQLException {
        ObjEntity entity;
        RowDescriptorBuilder builder = new RowDescriptorBuilder().setResultSet(resultSet).validateDuplicateColumnNames();
        if (compiled.getResultColumns().length > 0) {
            builder.setColumns(compiled.getResultColumns());
        }
        if ((entity = this.queryMetadata.getObjEntity()) != null) {
            for (ObjAttribute objAttribute : entity.getAttributes()) {
                String column = objAttribute.getDbAttributePath();
                if (column == null || column.indexOf(46) > 0) continue;
                builder.overrideColumnType(column, objAttribute.getType());
            }
        }
        if (this.dbEntity != null) {
            for (DbAttribute dbAttribute : this.dbEntity.getAttributes()) {
                if (builder.isOverriden(dbAttribute.getName()) || !TypesMapping.isNumeric(dbAttribute.getType())) continue;
                builder.overrideColumnType(dbAttribute.getName(), TypesMapping.getJavaBySqlType(dbAttribute.getType()));
            }
        }
        switch (this.query.getColumnNamesCapitalization()) {
            case LOWER: {
                builder.useLowercaseColumnNames();
                break;
            }
            case UPPER: {
                builder.useUppercaseColumnNames();
            }
        }
        return builder;
    }

    protected String extractTemplateString() {
        String sql = this.query.getTemplate(this.dbAdapter.getClass().getName());
        return Util.stripLineBreaks(sql, ' ');
    }

    protected void bind(PreparedStatement preparedStatement, ParameterBinding[] bindings) throws SQLException, Exception {
        for (ParameterBinding binding : bindings) {
            this.dataNode.getAdapter().bindParameter(preparedStatement, binding);
        }
        if (this.queryMetadata.getStatementFetchSize() != 0) {
            preparedStatement.setFetchSize(this.queryMetadata.getStatementFetchSize());
        }
    }

    public SQLTemplate getQuery() {
        return this.query;
    }

    protected int getFetchOffset() {
        return this.query.getFetchOffset();
    }
}

