/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.cayenne.Cayenne;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.access.DataContextEJBQLQueryCallback;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.map.LifecycleEvent;
import org.apache.cayenne.query.EJBQLQuery;
import org.apache.cayenne.reflect.LifecycleCallbackRegistry;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.testdo.testmap.Painting;
import org.apache.cayenne.unit.UnitDbAdapter;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class DataContextEJBQLQueryIT
extends ServerCase {
    @Inject
    private ObjectContext context;
    @Inject
    private DBHelper dbHelper;
    @Inject
    private UnitDbAdapter accessStackAdapter;
    private TableHelper tArtist;
    private TableHelper tPainting;

    @Before
    public void setUp() throws Exception {
        this.tArtist = new TableHelper(this.dbHelper, "ARTIST");
        this.tArtist.setColumns(new String[]{"ARTIST_ID", "ARTIST_NAME"});
        this.tPainting = new TableHelper(this.dbHelper, "PAINTING");
        this.tPainting.setColumns(new String[]{"PAINTING_ID", "ARTIST_ID", "PAINTING_TITLE", "ESTIMATED_PRICE"}).setColumnTypes(new int[]{4, -5, 12, 3});
    }

    private void createFourArtistsTwoPaintings() throws Exception {
        this.tArtist.insert(new Object[]{33001, "AA1"});
        this.tArtist.insert(new Object[]{33002, "AA2"});
        this.tArtist.insert(new Object[]{33003, "BB1"});
        this.tArtist.insert(new Object[]{33004, "BB2"});
        this.tPainting.insert(new Object[]{33001, 33001, "P1", 3000});
        this.tPainting.insert(new Object[]{33002, 33002, "P2", 5000});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSelectAggregatePostLoadCallback() throws Exception {
        this.createFourArtistsTwoPaintings();
        LifecycleCallbackRegistry existingCallbacks = this.context.getEntityResolver().getCallbackRegistry();
        LifecycleCallbackRegistry testCallbacks = new LifecycleCallbackRegistry(this.context.getEntityResolver());
        DataContextEJBQLQueryCallback listener = new DataContextEJBQLQueryCallback();
        testCallbacks.addDefaultListener(LifecycleEvent.POST_LOAD, listener, "postLoad");
        this.context.getEntityResolver().setCallbackRegistry(testCallbacks);
        try {
            String ejbql = "select count(p), count(distinct p.estimatedPrice), max(p.estimatedPrice), sum(p.estimatedPrice) from Painting p";
            EJBQLQuery query = new EJBQLQuery(ejbql);
            List data = this.context.performQuery(query);
            Assert.assertFalse((boolean)listener.postLoad);
            Assert.assertEquals((long)1L, (long)data.size());
            Assert.assertTrue((boolean)(data.get(0) instanceof Object[]));
        }
        finally {
            this.context.getEntityResolver().setCallbackRegistry(existingCallbacks);
        }
    }

    @Test
    public void testSelectAggregate() throws Exception {
        this.createFourArtistsTwoPaintings();
        String ejbql = "select count(p), count(distinct p.estimatedPrice), max(p.estimatedPrice), sum(p.estimatedPrice) from Painting p";
        EJBQLQuery query = new EJBQLQuery(ejbql);
        List data = this.context.performQuery(query);
        Assert.assertEquals((long)1L, (long)data.size());
        Assert.assertTrue((boolean)(data.get(0) instanceof Object[]));
        Object[] aggregates = (Object[])data.get(0);
        Assert.assertEquals((Object)new Long(2L), (Object)aggregates[0]);
        Assert.assertEquals((Object)new Long(2L), (Object)aggregates[1]);
        Assert.assertEquals((double)5000.0, (double)((BigDecimal)aggregates[2]).doubleValue(), (double)1.0E-5);
        Assert.assertEquals((double)8000.0, (double)((BigDecimal)aggregates[3]).doubleValue(), (double)1.0E-5);
    }

    @Test
    public void testSelectAggregateNull() throws Exception {
        if (!this.accessStackAdapter.supportNullRowForAggregateFunctions()) {
            return;
        }
        String ejbql = "select count(p), max(p.estimatedPrice), sum(p.estimatedPrice) from Painting p WHERE p.paintingTitle = 'X'";
        EJBQLQuery query = new EJBQLQuery(ejbql);
        List data = this.context.performQuery(query);
        Assert.assertEquals((long)1L, (long)data.size());
        Assert.assertTrue((boolean)(data.get(0) instanceof Object[]));
        Object[] aggregates = (Object[])data.get(0);
        Assert.assertEquals((Object)new Long(0L), (Object)aggregates[0]);
        Assert.assertEquals(null, (Object)aggregates[1]);
        Assert.assertEquals(null, (Object)aggregates[2]);
    }

    @Test
    public void testSelectEntityPathsScalarResult() throws Exception {
        this.createFourArtistsTwoPaintings();
        String ejbql = "select p.paintingTitle from Painting p order by p.paintingTitle DESC";
        EJBQLQuery query = new EJBQLQuery(ejbql);
        List data = this.context.performQuery(query);
        Assert.assertEquals((long)2L, (long)data.size());
        Assert.assertEquals((Object)"P2", data.get(0));
        Assert.assertEquals((Object)"P1", data.get(1));
    }

    @Test
    public void testSelectEntityPathsArrayResult() throws Exception {
        this.createFourArtistsTwoPaintings();
        String ejbql = "select p.estimatedPrice, p.toArtist.artistName from Painting p order by p.estimatedPrice";
        EJBQLQuery query = new EJBQLQuery(ejbql);
        List data = this.context.performQuery(query);
        Assert.assertEquals((long)2L, (long)data.size());
        Assert.assertTrue((boolean)(data.get(0) instanceof Object[]));
        Object[] row0 = (Object[])data.get(0);
        Assert.assertEquals((long)2L, (long)row0.length);
        Assert.assertEquals((double)3000.0, (double)((BigDecimal)row0[0]).doubleValue(), (double)1.0E-5);
        Assert.assertEquals((Object)"AA1", (Object)row0[1]);
        Assert.assertTrue((boolean)(data.get(1) instanceof Object[]));
        Object[] row1 = (Object[])data.get(1);
        Assert.assertEquals((long)2L, (long)row1.length);
        Assert.assertEquals((double)5000.0, (double)((BigDecimal)row1[0]).doubleValue(), (double)1.0E-5);
        Assert.assertEquals((Object)"AA2", (Object)row1[1]);
    }

    @Test
    public void testSelectDbPath() throws Exception {
        this.createFourArtistsTwoPaintings();
        String ejbql = "select db:p.ESTIMATED_PRICE from Painting p order by p.estimatedPrice";
        EJBQLQuery query = new EJBQLQuery(ejbql);
        List data = this.context.performQuery(query);
        Assert.assertEquals((long)2L, (long)data.size());
        Assert.assertEquals((double)3000.0, (double)((BigDecimal)data.get(0)).doubleValue(), (double)1.0E-5);
        Assert.assertEquals((double)5000.0, (double)((BigDecimal)data.get(1)).doubleValue(), (double)1.0E-5);
    }

    @Test
    public void testSelectDbPath_Relationship() throws Exception {
        this.createFourArtistsTwoPaintings();
        String ejbql = "select db:p.toArtist from Painting p order by p.estimatedPrice";
        EJBQLQuery query = new EJBQLQuery(ejbql);
        List data = this.context.performQuery(query);
        Assert.assertEquals((long)2L, (long)data.size());
        Assert.assertTrue((boolean)(data.get(0) instanceof Artist));
        Assert.assertEquals((long)33001L, (long)Cayenne.intPKForObject((Artist)data.get(0)));
        Assert.assertTrue((boolean)(data.get(1) instanceof Artist));
        Assert.assertEquals((long)33002L, (long)Cayenne.intPKForObject((Artist)data.get(1)));
    }

    @Test
    public void testSimpleSelect() throws Exception {
        this.createFourArtistsTwoPaintings();
        String ejbql = "select a FROM Artist a";
        EJBQLQuery query = new EJBQLQuery(ejbql);
        List artists = this.context.performQuery(query);
        Assert.assertEquals((long)4L, (long)artists.size());
        Assert.assertTrue((boolean)(artists.get(0) instanceof Artist));
        Assert.assertTrue((((Artist)artists.get(0)).getPersistenceState() == 3 ? 1 : 0) != 0);
    }

    @Test
    public void testFetchLimit() throws Exception {
        this.createFourArtistsTwoPaintings();
        String ejbql = "select a FROM Artist a";
        EJBQLQuery query = new EJBQLQuery(ejbql);
        query.setFetchLimit(2);
        List artists = this.context.performQuery(query);
        Assert.assertEquals((long)2L, (long)artists.size());
    }

    @Test
    public void testSelectFromWhereEqual() throws Exception {
        this.createFourArtistsTwoPaintings();
        String ejbql = "select a from Artist a where a.artistName = 'AA2'";
        EJBQLQuery query = new EJBQLQuery(ejbql);
        List artists = this.context.performQuery(query);
        Assert.assertEquals((long)1L, (long)artists.size());
        Assert.assertEquals((Object)"AA2", (Object)((Artist)artists.get(0)).getArtistName());
    }

    @Test
    public void testSelectFromWhereEqualReverseOrder() throws Exception {
        if (!this.accessStackAdapter.supportsReverseComparison()) {
            return;
        }
        this.createFourArtistsTwoPaintings();
        String ejbql = "select a from Artist a where 'AA2' = a.artistName";
        EJBQLQuery query = new EJBQLQuery(ejbql);
        List artists = this.context.performQuery(query);
        Assert.assertEquals((long)1L, (long)artists.size());
        Assert.assertEquals((Object)"AA2", (Object)((Artist)artists.get(0)).getArtistName());
    }

    @Test
    public void testSelectFromWhereNot() throws Exception {
        this.createFourArtistsTwoPaintings();
        String ejbql = "select a from Artist a where not a.artistName = 'AA2'";
        EJBQLQuery query = new EJBQLQuery(ejbql);
        List artists = this.context.performQuery(query);
        Assert.assertEquals((long)3L, (long)artists.size());
        for (Artist a : artists) {
            Assert.assertFalse((boolean)"AA2".equals(a.getArtistName()));
        }
    }

    @Test
    public void testSelectFromWhereNotEquals() throws Exception {
        this.createFourArtistsTwoPaintings();
        String ejbql = "select a from Artist a where a.artistName <> 'AA2'";
        EJBQLQuery query = new EJBQLQuery(ejbql);
        List artists = this.context.performQuery(query);
        Assert.assertEquals((long)3L, (long)artists.size());
        for (Artist a : artists) {
            Assert.assertFalse((boolean)"AA2".equals(a.getArtistName()));
        }
    }

    @Test
    public void testSelectFromWhereOrEqual() throws Exception {
        this.createFourArtistsTwoPaintings();
        String ejbql = "select a from Artist a where a.artistName = 'AA2' or a.artistName = 'BB1'";
        EJBQLQuery query = new EJBQLQuery(ejbql);
        List artists = this.context.performQuery(query);
        Assert.assertEquals((long)2L, (long)artists.size());
        HashSet<String> names = new HashSet<String>();
        Iterator it = artists.iterator();
        while (it.hasNext()) {
            names.add(((Artist)it.next()).getArtistName());
        }
        Assert.assertTrue((boolean)names.contains("AA2"));
        Assert.assertTrue((boolean)names.contains("BB1"));
    }

    @Test
    public void testSelectFromWhereAndEqual() throws Exception {
        this.createFourArtistsTwoPaintings();
        String ejbql = "select P from Painting P where P.paintingTitle = 'P1' AND p.estimatedPrice = 3000";
        EJBQLQuery query = new EJBQLQuery(ejbql);
        List ps = this.context.performQuery(query);
        Assert.assertEquals((long)1L, (long)ps.size());
        Painting p = (Painting)ps.get(0);
        Assert.assertEquals((Object)"P1", (Object)p.getPaintingTitle());
        Assert.assertEquals((double)3000.0, (double)p.getEstimatedPrice().doubleValue(), (double)1.0E-5);
    }

    @Test
    public void testSelectFromWhereBetween() throws Exception {
        this.createFourArtistsTwoPaintings();
        String ejbql = "select P from Painting P WHERE p.estimatedPrice BETWEEN 2000 AND 3500";
        EJBQLQuery query = new EJBQLQuery(ejbql);
        List ps = this.context.performQuery(query);
        Assert.assertEquals((long)1L, (long)ps.size());
        Painting p = (Painting)ps.get(0);
        Assert.assertEquals((Object)"P1", (Object)p.getPaintingTitle());
        Assert.assertEquals((double)3000.0, (double)p.getEstimatedPrice().doubleValue(), (double)1.0E-5);
    }

    @Test
    public void testSelectFromWhereNotBetween() throws Exception {
        this.createFourArtistsTwoPaintings();
        String ejbql = "select P from Painting P WHERE p.estimatedPrice NOT BETWEEN 2000 AND 3500";
        EJBQLQuery query = new EJBQLQuery(ejbql);
        List ps = this.context.performQuery(query);
        Assert.assertEquals((long)1L, (long)ps.size());
        Painting p = (Painting)ps.get(0);
        Assert.assertEquals((Object)"P2", (Object)p.getPaintingTitle());
        Assert.assertEquals((double)5000.0, (double)p.getEstimatedPrice().doubleValue(), (double)1.0E-5);
    }

    @Test
    public void testSelectFromWhereGreater() throws Exception {
        this.createFourArtistsTwoPaintings();
        String ejbql = "select P from Painting P WHERE p.estimatedPrice > 3000";
        EJBQLQuery query = new EJBQLQuery(ejbql);
        List ps = this.context.performQuery(query);
        Assert.assertEquals((long)1L, (long)ps.size());
        Painting p = (Painting)ps.get(0);
        Assert.assertEquals((Object)"P2", (Object)p.getPaintingTitle());
        Assert.assertEquals((double)5000.0, (double)p.getEstimatedPrice().doubleValue(), (double)1.0E-5);
    }

    @Test
    public void testSelectFromWhereGreaterOrEqual() throws Exception {
        this.createFourArtistsTwoPaintings();
        String ejbql = "select P from Painting P WHERE p.estimatedPrice >= 3000";
        EJBQLQuery query = new EJBQLQuery(ejbql);
        List ps = this.context.performQuery(query);
        Assert.assertEquals((long)2L, (long)ps.size());
    }

    @Test
    public void testSelectFromWhereLess() throws Exception {
        this.createFourArtistsTwoPaintings();
        String ejbql = "select P from Painting P WHERE p.estimatedPrice < 5000";
        EJBQLQuery query = new EJBQLQuery(ejbql);
        List ps = this.context.performQuery(query);
        Assert.assertEquals((long)1L, (long)ps.size());
        Painting p = (Painting)ps.get(0);
        Assert.assertEquals((Object)"P1", (Object)p.getPaintingTitle());
        Assert.assertEquals((double)3000.0, (double)p.getEstimatedPrice().doubleValue(), (double)1.0E-5);
    }

    @Test
    public void testSelectFromWhereLessOrEqual() throws Exception {
        this.createFourArtistsTwoPaintings();
        String ejbql = "select P from Painting P WHERE p.estimatedPrice <= 5000";
        EJBQLQuery query = new EJBQLQuery(ejbql);
        List ps = this.context.performQuery(query);
        Assert.assertEquals((long)2L, (long)ps.size());
    }

    @Test
    public void testSelectFromWhereDecimalNumber() throws Exception {
        this.createFourArtistsTwoPaintings();
        String ejbql = "select P from Painting P WHERE p.estimatedPrice <= 5000.00";
        EJBQLQuery query = new EJBQLQuery(ejbql);
        List ps = this.context.performQuery(query);
        Assert.assertEquals((long)2L, (long)ps.size());
    }

    @Test
    public void testSelectFromWhereDecimalNumberPositional() throws Exception {
        this.createFourArtistsTwoPaintings();
        String ejbql = "select P from Painting P WHERE p.estimatedPrice <= ?1";
        EJBQLQuery query = new EJBQLQuery(ejbql);
        query.setParameter(1, (Object)new BigDecimal(5000.0));
        List ps = this.context.performQuery(query);
        Assert.assertEquals((long)2L, (long)ps.size());
    }

    @Test
    public void testSelectFromWhereDecimalNumberNamed() throws Exception {
        this.createFourArtistsTwoPaintings();
        String ejbql = "select P from Painting P WHERE p.estimatedPrice <= :param";
        EJBQLQuery query = new EJBQLQuery(ejbql);
        query.setParameter("param", (Object)new BigDecimal(5000.0));
        List ps = this.context.performQuery(query);
        Assert.assertEquals((long)2L, (long)ps.size());
    }

    @Test
    public void testSelectFromWhereMatchOnObject() throws Exception {
        this.createFourArtistsTwoPaintings();
        Artist a = Cayenne.objectForPK(this.context, Artist.class, 33002);
        String ejbql = "select P from Painting P WHERE p.toArtist = :param";
        EJBQLQuery query = new EJBQLQuery(ejbql);
        query.setParameter("param", (Object)a);
        List ps = this.context.performQuery(query);
        Assert.assertEquals((long)1L, (long)ps.size());
        Painting p = (Painting)ps.get(0);
        Assert.assertEquals((long)33002L, (long)Cayenne.intPKForObject(p));
    }

    @Test
    public void testSelectFromWhereMatchRelationshipAndScalar() throws Exception {
        this.createFourArtistsTwoPaintings();
        String ejbql = "select P from Painting P WHERE p.toArtist = 33002";
        EJBQLQuery query = new EJBQLQuery(ejbql);
        List ps = this.context.performQuery(query);
        Assert.assertEquals((long)1L, (long)ps.size());
        Painting p = (Painting)ps.get(0);
        Assert.assertEquals((long)33002L, (long)Cayenne.intPKForObject(p));
    }
}

