/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.List;
import org.apache.cayenne.Cayenne;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.EJBQLQuery;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class DataContextEJBQLOrderByIT
extends ServerCase {
    @Inject
    private ObjectContext context;
    @Inject
    protected DBHelper dbHelper;
    protected TableHelper tArtist;
    protected TableHelper tPainting;

    @Before
    public void setUp() throws Exception {
        this.tArtist = new TableHelper(this.dbHelper, "ARTIST");
        this.tArtist.setColumns(new String[]{"ARTIST_ID", "ARTIST_NAME"});
        this.tPainting = new TableHelper(this.dbHelper, "PAINTING");
        this.tPainting.setColumns(new String[]{"PAINTING_ID", "ARTIST_ID", "PAINTING_TITLE", "ESTIMATED_PRICE"}).setColumnTypes(new int[]{4, -5, 12, 3});
    }

    private void createThreePaintings() throws Exception {
        this.tPainting.insert(new Object[]{33001, null, "A", 3000});
        this.tPainting.insert(new Object[]{33002, null, "B", 2000});
        this.tPainting.insert(new Object[]{33003, null, "C", 1000});
    }

    private void createFourPaintings() throws Exception {
        this.tPainting.insert(new Object[]{33001, null, "A", 3000});
        this.tPainting.insert(new Object[]{33002, null, "B", 2000});
        this.tPainting.insert(new Object[]{33003, null, "C", 1000});
        this.tPainting.insert(new Object[]{33004, null, "C", 500});
    }

    private void createTwoArtistsTwoPaintings() throws Exception {
        this.tArtist.insert(new Object[]{33001, "A"});
        this.tArtist.insert(new Object[]{33002, "B"});
        this.tPainting.insert(new Object[]{33005, 33001, "C", 500});
        this.tPainting.insert(new Object[]{33006, 33002, "C", 500});
    }

    @Test
    public void testOrderByDefault() throws Exception {
        this.createThreePaintings();
        String ejbql1 = "SELECT p FROM Painting p ORDER BY p.paintingTitle";
        EJBQLQuery query1 = new EJBQLQuery(ejbql1);
        List results1 = this.context.performQuery(query1);
        Assert.assertEquals((long)3L, (long)results1.size());
        Assert.assertEquals((long)33001L, (long)Cayenne.intPKForObject((Persistent)results1.get(0)));
        Assert.assertEquals((long)33002L, (long)Cayenne.intPKForObject((Persistent)results1.get(1)));
        Assert.assertEquals((long)33003L, (long)Cayenne.intPKForObject((Persistent)results1.get(2)));
        String ejbql2 = "SELECT p FROM Painting p ORDER BY p.estimatedPrice";
        EJBQLQuery query2 = new EJBQLQuery(ejbql2);
        List results2 = this.context.performQuery(query2);
        Assert.assertEquals((long)3L, (long)results2.size());
        Assert.assertEquals((long)33003L, (long)Cayenne.intPKForObject((Persistent)results2.get(0)));
        Assert.assertEquals((long)33002L, (long)Cayenne.intPKForObject((Persistent)results2.get(1)));
        Assert.assertEquals((long)33001L, (long)Cayenne.intPKForObject((Persistent)results2.get(2)));
    }

    @Test
    public void testOrderByAsc() throws Exception {
        this.createThreePaintings();
        String ejbql1 = "SELECT p FROM Painting p ORDER BY p.paintingTitle ASC";
        EJBQLQuery query1 = new EJBQLQuery(ejbql1);
        List results1 = this.context.performQuery(query1);
        Assert.assertEquals((long)3L, (long)results1.size());
        Assert.assertEquals((long)33001L, (long)Cayenne.intPKForObject((Persistent)results1.get(0)));
        Assert.assertEquals((long)33002L, (long)Cayenne.intPKForObject((Persistent)results1.get(1)));
        Assert.assertEquals((long)33003L, (long)Cayenne.intPKForObject((Persistent)results1.get(2)));
        String ejbql2 = "SELECT p FROM Painting p ORDER BY p.estimatedPrice ASC";
        EJBQLQuery query2 = new EJBQLQuery(ejbql2);
        List results2 = this.context.performQuery(query2);
        Assert.assertEquals((long)3L, (long)results2.size());
        Assert.assertEquals((long)33003L, (long)Cayenne.intPKForObject((Persistent)results2.get(0)));
        Assert.assertEquals((long)33002L, (long)Cayenne.intPKForObject((Persistent)results2.get(1)));
        Assert.assertEquals((long)33001L, (long)Cayenne.intPKForObject((Persistent)results2.get(2)));
    }

    @Test
    public void testOrderByDesc() throws Exception {
        this.createThreePaintings();
        String ejbql1 = "SELECT p FROM Painting p ORDER BY p.paintingTitle DESC";
        EJBQLQuery query1 = new EJBQLQuery(ejbql1);
        List results1 = this.context.performQuery(query1);
        Assert.assertEquals((long)3L, (long)results1.size());
        Assert.assertEquals((long)33003L, (long)Cayenne.intPKForObject((Persistent)results1.get(0)));
        Assert.assertEquals((long)33002L, (long)Cayenne.intPKForObject((Persistent)results1.get(1)));
        Assert.assertEquals((long)33001L, (long)Cayenne.intPKForObject((Persistent)results1.get(2)));
        String ejbql2 = "SELECT p FROM Painting p ORDER BY p.estimatedPrice DESC";
        EJBQLQuery query2 = new EJBQLQuery(ejbql2);
        List results2 = this.context.performQuery(query2);
        Assert.assertEquals((long)3L, (long)results2.size());
        Assert.assertEquals((long)33001L, (long)Cayenne.intPKForObject((Persistent)results2.get(0)));
        Assert.assertEquals((long)33002L, (long)Cayenne.intPKForObject((Persistent)results2.get(1)));
        Assert.assertEquals((long)33003L, (long)Cayenne.intPKForObject((Persistent)results2.get(2)));
    }

    @Test
    public void testOrderByQualified() throws Exception {
        this.createThreePaintings();
        String ejbql1 = "SELECT p FROM Painting p WHERE p.estimatedPrice > 1000 ORDER BY p.paintingTitle ASC";
        EJBQLQuery query1 = new EJBQLQuery(ejbql1);
        List results1 = this.context.performQuery(query1);
        Assert.assertEquals((long)2L, (long)results1.size());
        Assert.assertEquals((long)33001L, (long)Cayenne.intPKForObject((Persistent)results1.get(0)));
        Assert.assertEquals((long)33002L, (long)Cayenne.intPKForObject((Persistent)results1.get(1)));
        String ejbql2 = "SELECT p FROM Painting p WHERE p.estimatedPrice > 1000 ORDER BY p.estimatedPrice ASC";
        EJBQLQuery query2 = new EJBQLQuery(ejbql2);
        List results2 = this.context.performQuery(query2);
        Assert.assertEquals((long)2L, (long)results2.size());
        Assert.assertEquals((long)33002L, (long)Cayenne.intPKForObject((Persistent)results2.get(0)));
        Assert.assertEquals((long)33001L, (long)Cayenne.intPKForObject((Persistent)results2.get(1)));
    }

    @Test
    public void testOrderByMultiple() throws Exception {
        this.createFourPaintings();
        String ejbql1 = "SELECT p FROM Painting p ORDER BY p.paintingTitle DESC, p.estimatedPrice DESC";
        EJBQLQuery query1 = new EJBQLQuery(ejbql1);
        List results1 = this.context.performQuery(query1);
        Assert.assertEquals((long)4L, (long)results1.size());
        Assert.assertEquals((long)33003L, (long)Cayenne.intPKForObject((Persistent)results1.get(0)));
        Assert.assertEquals((long)33004L, (long)Cayenne.intPKForObject((Persistent)results1.get(1)));
        Assert.assertEquals((long)33002L, (long)Cayenne.intPKForObject((Persistent)results1.get(2)));
        Assert.assertEquals((long)33001L, (long)Cayenne.intPKForObject((Persistent)results1.get(3)));
    }

    @Test
    public void testOrderByPath() throws Exception {
        this.createTwoArtistsTwoPaintings();
        String ejbql1 = "SELECT p FROM Painting p ORDER BY p.toArtist.artistName ASC";
        EJBQLQuery query1 = new EJBQLQuery(ejbql1);
        List results1 = this.context.performQuery(query1);
        Assert.assertEquals((long)2L, (long)results1.size());
        Assert.assertEquals((long)33005L, (long)Cayenne.intPKForObject((Persistent)results1.get(0)));
        Assert.assertEquals((long)33006L, (long)Cayenne.intPKForObject((Persistent)results1.get(1)));
        String ejbql2 = "SELECT p FROM Painting p ORDER BY p.toArtist.artistName DESC";
        EJBQLQuery query2 = new EJBQLQuery(ejbql2);
        List results2 = this.context.performQuery(query2);
        Assert.assertEquals((long)2L, (long)results2.size());
        Assert.assertEquals((long)33006L, (long)Cayenne.intPKForObject((Persistent)results2.get(0)));
        Assert.assertEquals((long)33005L, (long)Cayenne.intPKForObject((Persistent)results2.get(1)));
    }
}

