/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.util;

import org.apache.cayenne.Cayenne;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.configuration.server.ServerRuntime;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.ObjectIdQuery;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.testdo.testmap.Painting;
import org.apache.cayenne.unit.di.DataChannelInterceptor;
import org.apache.cayenne.unit.di.UnitTestClosure;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.apache.cayenne.util.ShallowMergeOperation;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class ShallowMergeOperationIT
extends ServerCase {
    @Inject
    private ServerRuntime runtime;
    @Inject
    private DataContext context;
    @Inject
    private DataChannelInterceptor queryInterceptor;
    @Inject
    private DBHelper dbHelper;
    private TableHelper tArtist;

    @Before
    public void setUp() throws Exception {
        this.tArtist = new TableHelper(this.dbHelper, "ARTIST");
        this.tArtist.setColumns(new String[]{"ARTIST_ID", "ARTIST_NAME"});
    }

    private void createArtistsDataSet() throws Exception {
        this.tArtist.insert(new Object[]{33001, "artist1"});
        this.tArtist.insert(new Object[]{33002, "artist2"});
        this.tArtist.insert(new Object[]{33003, "artist3"});
        this.tArtist.insert(new Object[]{33004, "artist4"});
    }

    @Test
    public void testMerge_Relationship() throws Exception {
        ObjectContext childContext = this.runtime.newContext(this.context);
        final ShallowMergeOperation op = new ShallowMergeOperation(childContext);
        Artist _new = this.context.newObject(Artist.class);
        final Painting _newP = this.context.newObject(Painting.class);
        _new.addToPaintingArray(_newP);
        this.queryInterceptor.runWithQueriesBlocked(new UnitTestClosure(){

            @Override
            public void execute() {
                Painting painting = op.merge(_newP);
                Assert.assertEquals((long)3L, (long)painting.getPersistenceState());
                Assert.assertNotNull((Object)painting.getToArtist());
                Assert.assertEquals((long)3L, (long)painting.getToArtist().getPersistenceState());
            }
        });
    }

    @Test
    public void testMerge_NoOverride() throws Exception {
        this.createArtistsDataSet();
        ObjectContext childContext = this.runtime.newContext(this.context);
        final ShallowMergeOperation op = new ShallowMergeOperation(childContext);
        int modifiedId = 33003;
        final Artist modified = (Artist)Cayenne.objectForQuery(this.context, new ObjectIdQuery(new ObjectId("Artist", "ARTIST_ID", modifiedId)));
        final Artist peerModified = (Artist)Cayenne.objectForQuery(childContext, new ObjectIdQuery(new ObjectId("Artist", "ARTIST_ID", modifiedId)));
        modified.setArtistName("M1");
        peerModified.setArtistName("M2");
        Assert.assertEquals((long)4L, (long)modified.getPersistenceState());
        Assert.assertEquals((long)4L, (long)peerModified.getPersistenceState());
        this.queryInterceptor.runWithQueriesBlocked(new UnitTestClosure(){

            @Override
            public void execute() {
                Artist peerModified2 = op.merge(modified);
                Assert.assertSame((Object)peerModified, (Object)peerModified2);
                Assert.assertEquals((long)4L, (long)peerModified2.getPersistenceState());
                Assert.assertEquals((Object)"M2", (Object)peerModified.getArtistName());
                Assert.assertEquals((Object)"M1", (Object)modified.getArtistName());
            }
        });
    }

    @Test
    public void testMerge_PersistenceStates() throws Exception {
        this.createArtistsDataSet();
        final ObjectContext childContext = this.runtime.newContext(this.context);
        final ShallowMergeOperation op = new ShallowMergeOperation(childContext);
        final Artist _new = this.context.newObject(Artist.class);
        final Artist hollow = Cayenne.objectForPK((ObjectContext)this.context, Artist.class, 33001);
        this.context.invalidateObjects(hollow);
        final Artist committed = Cayenne.objectForPK((ObjectContext)this.context, Artist.class, 33002);
        final Artist modified = Cayenne.objectForPK((ObjectContext)this.context, Artist.class, 33003);
        modified.setArtistName("M1");
        final Artist deleted = Cayenne.objectForPK((ObjectContext)this.context, Artist.class, 33004);
        this.context.deleteObjects(deleted);
        Assert.assertEquals((long)5L, (long)hollow.getPersistenceState());
        Assert.assertEquals((long)3L, (long)committed.getPersistenceState());
        Assert.assertEquals((long)4L, (long)modified.getPersistenceState());
        Assert.assertEquals((long)6L, (long)deleted.getPersistenceState());
        Assert.assertEquals((long)2L, (long)_new.getPersistenceState());
        this.queryInterceptor.runWithQueriesBlocked(new UnitTestClosure(){

            @Override
            public void execute() {
                Artist newPeer = op.merge(_new);
                Assert.assertEquals((Object)_new.getObjectId(), (Object)newPeer.getObjectId());
                Assert.assertEquals((long)3L, (long)newPeer.getPersistenceState());
                Assert.assertSame((Object)childContext, (Object)newPeer.getObjectContext());
                Assert.assertSame((Object)ShallowMergeOperationIT.this.context, (Object)_new.getObjectContext());
                Artist hollowPeer = op.merge(hollow);
                Assert.assertEquals((long)5L, (long)hollowPeer.getPersistenceState());
                Assert.assertEquals((Object)hollow.getObjectId(), (Object)hollowPeer.getObjectId());
                Assert.assertSame((Object)childContext, (Object)hollowPeer.getObjectContext());
                Assert.assertSame((Object)ShallowMergeOperationIT.this.context, (Object)hollow.getObjectContext());
                Artist committedPeer = op.merge(committed);
                Assert.assertEquals((long)3L, (long)committedPeer.getPersistenceState());
                Assert.assertEquals((Object)committed.getObjectId(), (Object)committedPeer.getObjectId());
                Assert.assertSame((Object)childContext, (Object)committedPeer.getObjectContext());
                Assert.assertSame((Object)ShallowMergeOperationIT.this.context, (Object)committed.getObjectContext());
                Artist modifiedPeer = op.merge(modified);
                Assert.assertEquals((long)3L, (long)modifiedPeer.getPersistenceState());
                Assert.assertEquals((Object)modified.getObjectId(), (Object)modifiedPeer.getObjectId());
                Assert.assertEquals((Object)"M1", (Object)modifiedPeer.getArtistName());
                Assert.assertSame((Object)childContext, (Object)modifiedPeer.getObjectContext());
                Assert.assertSame((Object)ShallowMergeOperationIT.this.context, (Object)modified.getObjectContext());
                Artist deletedPeer = op.merge(deleted);
                Assert.assertEquals((long)3L, (long)deletedPeer.getPersistenceState());
                Assert.assertEquals((Object)deleted.getObjectId(), (Object)deletedPeer.getObjectId());
                Assert.assertSame((Object)childContext, (Object)deletedPeer.getObjectContext());
                Assert.assertSame((Object)ShallowMergeOperationIT.this.context, (Object)deleted.getObjectContext());
            }
        });
    }
}

