/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.tx;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.log.JdbcEventLogger;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.tx.BaseTransaction;
import org.apache.cayenne.tx.CayenneTransaction;
import org.apache.cayenne.tx.Transaction;
import org.apache.cayenne.tx.TransactionListener;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class UserTransactionIT
extends ServerCase {
    @Inject
    private ObjectContext context;
    @Inject
    private JdbcEventLogger logger;

    @Test
    public void testCommit() throws Exception {
        Artist a = this.context.newObject(Artist.class);
        a.setArtistName("AAA");
        TxWrapper t = new TxWrapper(new CayenneTransaction(this.logger));
        BaseTransaction.bindThreadTransaction(t);
        try {
            this.context.commitChanges();
        }
        finally {
            t.rollback();
            BaseTransaction.bindThreadTransaction(null);
        }
        Assert.assertEquals((long)0L, (long)t.commitCount);
        Assert.assertEquals((long)1L, (long)t.getConnections().size());
    }

    class TxWrapper
    implements Transaction {
        int commitCount;
        private Transaction delegate;

        TxWrapper(Transaction delegate) {
            this.delegate = delegate;
        }

        @Override
        public void begin() {
            this.delegate.begin();
        }

        @Override
        public void commit() {
            ++this.commitCount;
            this.delegate.commit();
        }

        @Override
        public void rollback() {
            this.delegate.rollback();
        }

        @Override
        public void setRollbackOnly() {
            this.delegate.setRollbackOnly();
        }

        @Override
        public boolean isRollbackOnly() {
            return this.delegate.isRollbackOnly();
        }

        @Override
        public Connection getOrCreateConnection(String connectionName, DataSource dataSource) throws SQLException {
            return this.delegate.getOrCreateConnection(connectionName, dataSource);
        }

        @Override
        public Map<String, Connection> getConnections() {
            return this.delegate.getConnections();
        }

        @Override
        public void addListener(TransactionListener listener) {
            this.delegate.addListener(listener);
        }

        @Override
        public boolean isExternal() {
            return false;
        }
    }
}

