/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.exp.FunctionExpressionFactory;
import org.apache.cayenne.exp.parser.ASTPath;
import org.apache.cayenne.query.Ordering;
import org.apache.cayenne.query.Orderings;
import org.apache.cayenne.query.PrefetchTreeNode;
import org.apache.cayenne.query.SortOrder;
import org.apache.cayenne.reflect.PropertyUtils;

public class Property<E> {
    public static final Property<Long> COUNT = Property.create(FunctionExpressionFactory.countExp(), Long.class);
    private final String name;
    private final ExpressionProvider expressionProvider;
    private final Class<? super E> type;

    @Deprecated
    public Property(String name) {
        this(name, null);
    }

    protected Property(final String name, Class<? super E> type) {
        this.name = name;
        this.expressionProvider = new ExpressionProvider(){

            @Override
            public Expression get() {
                return ExpressionFactory.pathExp(name);
            }
        };
        this.type = type;
    }

    protected Property(String name, final Expression expression, Class<? super E> type) {
        this.name = name;
        this.expressionProvider = new ExpressionProvider(){

            @Override
            public Expression get() {
                return expression.deepCopy();
            }
        };
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public String getAlias() {
        if (this.getName() == null) {
            return null;
        }
        Expression exp = this.getExpression();
        if (exp instanceof ASTPath && ((ASTPath)exp).getPath().equals(this.getName())) {
            return null;
        }
        return this.getName();
    }

    public Expression getExpression() {
        return this.expressionProvider.get();
    }

    public int hashCode() {
        int result;
        int n = result = this.name != null ? this.name.hashCode() : this.expressionProvider.get().hashCode();
        if (this.type != null) {
            result = 31 * result + this.type.hashCode();
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Property property = (Property)o;
        if (this.name != null ? !this.name.equals(property.name) : property.name != null) {
            return false;
        }
        if (this.name == null && !this.expressionProvider.get().equals(property.expressionProvider.get())) {
            return false;
        }
        return this.type == null ? property.type == null : this.type.equals(property.type);
    }

    public Property<Object> dot(String property) {
        return Property.create(this.getName() + "." + property, null);
    }

    public <T> Property<T> dot(Property<T> property) {
        return Property.create(this.getName() + "." + property.getName(), property.getType());
    }

    public Property<E> outer() {
        return this.isOuter() ? this : Property.create(this.name + "+", this.type);
    }

    private boolean isOuter() {
        return this.name.endsWith("+");
    }

    public Expression path() {
        return this.getExpression();
    }

    public Expression isNull() {
        return ExpressionFactory.matchExp(this.getExpression(), null);
    }

    public Expression isNotNull() {
        return ExpressionFactory.matchExp(this.getExpression(), null).notExp();
    }

    public Expression isTrue() {
        return ExpressionFactory.matchExp(this.getExpression(), (Object)Boolean.TRUE);
    }

    public Expression isFalse() {
        return ExpressionFactory.matchExp(this.getExpression(), (Object)Boolean.FALSE);
    }

    public Expression eq(E value) {
        return ExpressionFactory.matchExp(this.getExpression(), value);
    }

    public Expression eq(Property<?> value) {
        return ExpressionFactory.matchExp(this.getExpression(), (Object)value.getExpression());
    }

    public Expression ne(E value) {
        return ExpressionFactory.noMatchExp(this.getExpression(), value);
    }

    public Expression ne(Property<?> value) {
        return ExpressionFactory.noMatchExp(this.getExpression(), (Object)value.getExpression());
    }

    public Expression like(String pattern) {
        return ExpressionFactory.likeExp(this.getExpression(), (Object)pattern);
    }

    public Expression like(String pattern, char escapeChar) {
        return ExpressionFactory.likeExp(this.getExpression(), (Object)pattern, escapeChar);
    }

    public Expression likeIgnoreCase(String pattern) {
        return ExpressionFactory.likeIgnoreCaseExp(this.getExpression(), (Object)pattern);
    }

    public Expression nlike(String value) {
        return ExpressionFactory.notLikeExp(this.getExpression(), (Object)value);
    }

    public Expression nlikeIgnoreCase(String value) {
        return ExpressionFactory.notLikeIgnoreCaseExp(this.getExpression(), (Object)value);
    }

    public Expression contains(String substring) {
        return ExpressionFactory.containsExp(this.getExpression(), substring);
    }

    public Expression startsWith(String value) {
        return ExpressionFactory.startsWithExp(this.getExpression(), value);
    }

    public Expression endsWith(String value) {
        return ExpressionFactory.endsWithExp(this.getExpression(), value);
    }

    public Expression containsIgnoreCase(String value) {
        return ExpressionFactory.containsIgnoreCaseExp(this.getExpression(), value);
    }

    public Expression startsWithIgnoreCase(String value) {
        return ExpressionFactory.startsWithIgnoreCaseExp(this.getExpression(), value);
    }

    public Expression endsWithIgnoreCase(String value) {
        return ExpressionFactory.endsWithIgnoreCaseExp(this.getExpression(), value);
    }

    public Expression between(E lower, E upper) {
        return ExpressionFactory.betweenExp(this.getExpression(), lower, upper);
    }

    public Expression in(E firstValue, E ... moreValues) {
        int moreValuesLength = moreValues != null ? moreValues.length : 0;
        Object[] values = new Object[moreValuesLength + 1];
        values[0] = firstValue;
        if (moreValuesLength > 0) {
            System.arraycopy(moreValues, 0, values, 1, moreValuesLength);
        }
        return ExpressionFactory.inExp(this.getExpression(), values);
    }

    public Expression nin(E firstValue, E ... moreValues) {
        int moreValuesLength = moreValues != null ? moreValues.length : 0;
        Object[] values = new Object[moreValuesLength + 1];
        values[0] = firstValue;
        if (moreValuesLength > 0) {
            System.arraycopy(moreValues, 0, values, 1, moreValuesLength);
        }
        return ExpressionFactory.notInExp(this.getExpression(), values);
    }

    public Expression in(Collection<E> values) {
        return ExpressionFactory.inExp(this.getExpression(), values);
    }

    public Expression nin(Collection<E> values) {
        return ExpressionFactory.notInExp(this.getExpression(), values);
    }

    public Expression gt(E value) {
        return ExpressionFactory.greaterExp(this.getExpression(), value);
    }

    public Expression gt(Property<?> value) {
        return ExpressionFactory.greaterExp(this.getExpression(), (Object)value.getExpression());
    }

    public Expression gte(E value) {
        return ExpressionFactory.greaterOrEqualExp(this.getExpression(), value);
    }

    public Expression gte(Property<?> value) {
        return ExpressionFactory.greaterOrEqualExp(this.getExpression(), (Object)value.getExpression());
    }

    public Expression lt(E value) {
        return ExpressionFactory.lessExp(this.getExpression(), value);
    }

    public Expression lt(Property<?> value) {
        return ExpressionFactory.lessExp(this.getExpression(), (Object)value.getExpression());
    }

    public Expression lte(E value) {
        return ExpressionFactory.lessOrEqualExp(this.getExpression(), value);
    }

    public Expression lte(Property<?> value) {
        return ExpressionFactory.lessOrEqualExp(this.getExpression(), (Object)value.getExpression());
    }

    public Ordering asc() {
        return new Ordering(this.getExpression(), SortOrder.ASCENDING);
    }

    public Orderings ascs() {
        return new Orderings(this.asc());
    }

    public Ordering ascInsensitive() {
        return new Ordering(this.getExpression(), SortOrder.ASCENDING_INSENSITIVE);
    }

    public Orderings ascInsensitives() {
        return new Orderings(this.ascInsensitive());
    }

    public Ordering desc() {
        return new Ordering(this.getExpression(), SortOrder.DESCENDING);
    }

    public Orderings descs() {
        return new Orderings(this.desc());
    }

    public Ordering descInsensitive() {
        return new Ordering(this.getExpression(), SortOrder.DESCENDING_INSENSITIVE);
    }

    public Orderings descInsensitives() {
        return new Orderings(this.descInsensitive());
    }

    public PrefetchTreeNode joint() {
        return PrefetchTreeNode.withPath(this.getName(), 1);
    }

    public PrefetchTreeNode disjoint() {
        return PrefetchTreeNode.withPath(this.getName(), 2);
    }

    public PrefetchTreeNode disjointById() {
        return PrefetchTreeNode.withPath(this.getName(), 3);
    }

    public E getFrom(Object bean) {
        return (E)PropertyUtils.getProperty(bean, this.getName());
    }

    public List<E> getFromAll(Collection<?> beans) {
        ArrayList<E> result = new ArrayList<E>(beans.size());
        for (Object bean : beans) {
            result.add(this.getFrom(bean));
        }
        return result;
    }

    public void setIn(Object bean, E value) {
        PropertyUtils.setProperty(bean, this.getName(), value);
    }

    public void setInAll(Collection<?> beans, E value) {
        for (Object bean : beans) {
            this.setIn(bean, value);
        }
    }

    public Property<Long> count() {
        return Property.create(FunctionExpressionFactory.countExp(this.getExpression()), Long.class);
    }

    public Property<E> max() {
        return Property.create(FunctionExpressionFactory.maxExp(this.getExpression()), this.getType());
    }

    public Property<E> min() {
        return Property.create(FunctionExpressionFactory.minExp(this.getExpression()), this.getType());
    }

    public Property<E> avg() {
        return Property.create(FunctionExpressionFactory.avgExp(this.getExpression()), this.getType());
    }

    public Property<E> sum() {
        return Property.create(FunctionExpressionFactory.sumExp(this.getExpression()), this.getType());
    }

    public Property<E> mod(Number number) {
        return Property.create(FunctionExpressionFactory.modExp(this.getExpression(), number), this.getType());
    }

    public Property<E> abs() {
        return Property.create(FunctionExpressionFactory.absExp(this.getExpression()), this.getType());
    }

    public Property<E> sqrt() {
        return Property.create(FunctionExpressionFactory.sqrtExp(this.getExpression()), this.getType());
    }

    public Property<Integer> length() {
        return Property.create(FunctionExpressionFactory.lengthExp(this.getExpression()), Integer.class);
    }

    public Property<Integer> locate(String string) {
        return Property.create(FunctionExpressionFactory.locateExp(ExpressionFactory.wrapScalarValue(string), this.getExpression()), Integer.class);
    }

    public Property<Integer> locate(Property<? extends String> property) {
        return Property.create(FunctionExpressionFactory.locateExp(property.getExpression(), this.getExpression()), Integer.class);
    }

    public Property<String> trim() {
        return Property.create(FunctionExpressionFactory.trimExp(this.getExpression()), String.class);
    }

    public Property<String> upper() {
        return Property.create(FunctionExpressionFactory.upperExp(this.getExpression()), String.class);
    }

    public Property<String> lower() {
        return Property.create(FunctionExpressionFactory.lowerExp(this.getExpression()), String.class);
    }

    public Property<String> concat(Object ... args) {
        Expression[] exp = new Expression[args.length + 1];
        int i = 0;
        exp[i++] = this.getExpression();
        for (Object arg : args) {
            if (arg instanceof Property) {
                exp[i++] = ((Property)arg).getExpression();
                continue;
            }
            if (arg instanceof Expression) {
                exp[i++] = (Expression)arg;
                continue;
            }
            if (arg == null) continue;
            exp[i++] = ExpressionFactory.wrapScalarValue(arg.toString());
        }
        return Property.create(FunctionExpressionFactory.concatExp(exp), String.class);
    }

    public Property<String> substring(int offset, int length) {
        return Property.create(FunctionExpressionFactory.substringExp(this.getExpression(), offset, length), String.class);
    }

    public Property<E> alias(String alias) {
        return new Property<E>(alias, this.getExpression(), this.getType());
    }

    public <T extends Persistent> Property<T> flat(Class<? super T> tClass) {
        if (!Collection.class.isAssignableFrom(this.type) && !Map.class.isAssignableFrom(this.type)) {
            throw new CayenneRuntimeException("Can use flat() function only on Property mapped on toMany relationship.", new Object[0]);
        }
        return Property.create(ExpressionFactory.fullObjectExp(this.getExpression()), tClass);
    }

    public Class<? super E> getType() {
        return this.type;
    }

    public static <T> Property<T> create(String name, Class<? super T> type) {
        return new Property<T>(name, type);
    }

    public static <T> Property<T> create(Expression expression, Class<? super T> type) {
        return new Property<T>(null, expression, type);
    }

    public static <T> Property<T> create(String name, Expression expression, Class<? super T> type) {
        return new Property<T>(name, expression, type);
    }

    public static <T extends Persistent> Property<T> createSelf(Class<? super T> type) {
        return new Property<T>(null, ExpressionFactory.fullObjectExp(), type);
    }

    private static interface ExpressionProvider {
        public Expression get();
    }
}

