/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.configuration.xml;

import java.io.InputStream;
import org.apache.cayenne.configuration.xml.DbKeyGeneratorHandlerTest;
import org.apache.cayenne.configuration.xml.DefaultHandlerFactory;
import org.apache.cayenne.configuration.xml.LoaderContext;
import org.apache.cayenne.configuration.xml.NamespaceAwareNestedTagHandler;
import org.apache.cayenne.util.Util;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public abstract class BaseHandlerTest {
    protected void parse(String tag, HandlerFactory factory) throws Exception {
        try (InputStream in = DbKeyGeneratorHandlerTest.class.getResource(this.getClass().getSimpleName() + ".xml").openStream();){
            XMLReader parser = Util.createXmlReader();
            TestRootHandler handler = new TestRootHandler(parser, tag, factory);
            parser.setContentHandler(handler);
            parser.parse(new InputSource(in));
        }
    }

    public static class TestRootHandler
    extends NamespaceAwareNestedTagHandler {
        private String rootTag;
        private HandlerFactory factory;

        public TestRootHandler(XMLReader parser, String rootTag, HandlerFactory factory) {
            super(new LoaderContext(parser, new DefaultHandlerFactory()));
            this.setTargetNamespace("");
            this.rootTag = rootTag;
            this.factory = factory;
        }

        @Override
        protected boolean processElement(String namespaceURI, String localName, Attributes attributes) throws SAXException {
            return false;
        }

        @Override
        protected ContentHandler createChildTagHandler(String namespaceURI, String localName, String qName, Attributes attributes) {
            if (localName.equals(this.rootTag)) {
                return this.factory.createHandler(this);
            }
            return super.createChildTagHandler(namespaceURI, localName, qName, attributes);
        }
    }

    public static interface HandlerFactory {
        public NamespaceAwareNestedTagHandler createHandler(NamespaceAwareNestedTagHandler var1);
    }
}

