/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.translator.ejbql;

import org.apache.cayenne.access.translator.ejbql.EJBQLJoinAppender;
import org.apache.cayenne.access.translator.ejbql.EJBQLTableId;
import org.apache.cayenne.access.translator.ejbql.EJBQLTranslationContext;
import org.apache.cayenne.ejbql.EJBQLBaseVisitor;
import org.apache.cayenne.ejbql.EJBQLExpression;
import org.apache.cayenne.ejbql.parser.EJBQLFromItem;
import org.apache.cayenne.ejbql.parser.EJBQLInnerFetchJoin;
import org.apache.cayenne.ejbql.parser.EJBQLJoin;
import org.apache.cayenne.ejbql.parser.EJBQLOuterFetchJoin;

public class EJBQLFromTranslator
extends EJBQLBaseVisitor {
    protected EJBQLTranslationContext context;
    private String lastId;
    private EJBQLJoinAppender joinAppender;

    public EJBQLFromTranslator(EJBQLTranslationContext context) {
        super(true);
        this.context = context;
        this.joinAppender = context.getTranslatorFactory().getJoinAppender(context);
    }

    @Override
    public boolean visitFrom(EJBQLExpression expression, int finishedChildIndex) {
        if (finishedChildIndex + 1 == expression.getChildrenCount() && this.lastId != null) {
            this.context.markCurrentPosition(EJBQLJoinAppender.makeJoinTailMarker(this.lastId));
        }
        return true;
    }

    @Override
    public boolean visitFromItem(EJBQLFromItem expression, int finishedChildIndex) {
        String id = expression.getId();
        if (this.lastId != null) {
            this.context.append(',');
            this.context.markCurrentPosition(EJBQLJoinAppender.makeJoinTailMarker(this.lastId));
        }
        this.lastId = id;
        this.joinAppender.appendTable(new EJBQLTableId(id));
        return false;
    }

    @Override
    public boolean visitInnerFetchJoin(EJBQLJoin join) {
        this.joinAppender.appendInnerJoin(null, new EJBQLTableId(join.getLeftHandSideId()), new EJBQLTableId(((EJBQLInnerFetchJoin)join).getRightHandSideId()));
        this.context.markCurrentPosition(EJBQLJoinAppender.makeJoinTailMarker(((EJBQLInnerFetchJoin)join).getRightHandSideId()));
        return false;
    }

    @Override
    public boolean visitInnerJoin(EJBQLJoin join) {
        this.joinAppender.appendInnerJoin(null, new EJBQLTableId(join.getLeftHandSideId()), new EJBQLTableId(join.getRightHandSideId()));
        this.context.markCurrentPosition(EJBQLJoinAppender.makeJoinTailMarker(join.getRightHandSideId()));
        return false;
    }

    @Override
    public boolean visitOuterFetchJoin(EJBQLJoin join) {
        this.joinAppender.appendOuterJoin(null, new EJBQLTableId(join.getLeftHandSideId()), new EJBQLTableId(((EJBQLOuterFetchJoin)join).getRightHandSideId()));
        this.context.markCurrentPosition(EJBQLJoinAppender.makeJoinTailMarker(((EJBQLOuterFetchJoin)join).getRightHandSideId()));
        return false;
    }

    @Override
    public boolean visitOuterJoin(EJBQLJoin join) {
        this.joinAppender.appendOuterJoin(null, new EJBQLTableId(join.getLeftHandSideId()), new EJBQLTableId(join.getRightHandSideId()));
        this.context.markCurrentPosition(EJBQLJoinAppender.makeJoinTailMarker(join.getRightHandSideId()));
        return false;
    }
}

