/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.unit.util;

import java.util.ArrayList;
import java.util.Objects;
import java.util.ServiceLoader;
import org.apache.cayenne.di.spi.ModuleProvider;
import org.junit.Assert;

public class ModuleProviderChecker {
    private Class<? extends ModuleProvider> expectedProvider;
    private Class<? extends ModuleProvider> providerInterface;

    public static void testProviderPresent(Class<? extends ModuleProvider> expectedProvider, Class<? extends ModuleProvider> providerInterface) {
        new ModuleProviderChecker(expectedProvider, providerInterface).testProviderPresent();
    }

    protected ModuleProviderChecker(Class<? extends ModuleProvider> expectedProvider, Class<? extends ModuleProvider> providerInterface) {
        this.expectedProvider = Objects.requireNonNull(expectedProvider);
        this.providerInterface = Objects.requireNonNull(providerInterface);
        Assert.assertTrue((String)"Provider interface expected", (boolean)providerInterface.isInterface());
        if (expectedProvider.equals(providerInterface)) {
            Assert.fail((String)"Expected provider class and required interface should be different.");
        }
    }

    protected void testProviderPresent() {
        ArrayList<ModuleProvider> providers = new ArrayList<ModuleProvider>();
        for (ModuleProvider moduleProvider : ServiceLoader.load(this.providerInterface)) {
            if (!this.expectedProvider.equals(moduleProvider.getClass())) continue;
            providers.add(moduleProvider);
        }
        switch (providers.size()) {
            case 0: {
                Assert.fail((String)("Expected provider '" + this.expectedProvider.getName() + "' is not found"));
                break;
            }
            case 1: {
                break;
            }
            default: {
                Assert.fail((String)("Expected provider '" + this.expectedProvider.getName() + "' is found more then once: " + providers.size()));
            }
        }
    }
}

